/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Random;
import org.joml.Vector3f;

public class VerticalSlashParticle
extends TextureSheetParticle {
    public final SpriteSet spriteProvider;
    float modifierX = new Random().nextInt(35);
    float modifierZ = new Random().nextInt(70);

    public VerticalSlashParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.spriteProvider = spriteProvider;
        float modifier = (float)new Random().nextInt(60) / 100.0f;
        this.quadSize = 0.7f + modifier;
        this.lifetime = 5;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Quaternionf quaternion2;
        this.setSpriteFromAge(this.spriteProvider);
        Vec3 vec3d = camera.getPosition();
        float f = (float)(Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x) - vec3d.x());
        float g = (float)(Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y) - vec3d.y());
        float h = (float)(Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z) - vec3d.z());
        if (this.roll == 0.5f) {
            quaternion2 = camera.rotation();
        } else {
            quaternion2 = new Quaternionf((Quaternionfc)camera.rotation());
            float i = Mth.lerp((float)tickDelta, (float)this.oRoll, (float)this.roll);
            quaternion2.rotateZ(i);
        }
        Vector3f vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        vec3f.rotate((Quaternionfc)quaternion2);
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.getQuadSize(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f Vec3f2 = Vec3fs[k];
            Vec3f2.rotate((Quaternionfc)new Quaternionf().rotateXYZ((float)Math.toRadians(110.0f + this.modifierX), 0.0f, -320.0f + this.modifierZ));
            Vec3f2.mul(j);
            Vec3f2.add(f, g, h);
        }
        float minU = this.getU0();
        float maxU = this.getU1();
        float minV = this.getV0();
        float maxV = this.getV1();
        int l = this.getLightColor(tickDelta);
        vertexConsumer.addVertex(Vec3fs[0].x(), Vec3fs[0].y(), Vec3fs[0].z()).setUv(maxU, maxV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(l);
        vertexConsumer.addVertex(Vec3fs[1].x(), Vec3fs[1].y(), Vec3fs[1].z()).setUv(maxU, minV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(l);
        vertexConsumer.addVertex(Vec3fs[2].x(), Vec3fs[2].y(), Vec3fs[2].z()).setUv(minU, minV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(l);
        vertexConsumer.addVertex(Vec3fs[3].x(), Vec3fs[3].y(), Vec3fs[3].z()).setUv(minU, maxV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(l);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public DefaultFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new VerticalSlashParticle(world, x, y, z, velocityX, velocityY, velocityZ, this.spriteProvider);
        }
    }
}

