/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.util.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.item.ScrollItem;
import net.spell_engine.item.SpellEngineItems;
import org.jetbrains.annotations.Nullable;

public class SpecificSpellScrollPoolLootFunction
extends LootItemConditionalFunction {
    public static final String NAME = "specific_spell_scroll_pool";
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"more_rpg_classes", (String)"specific_spell_scroll_pool");
    public static final MapCodec<SpecificSpellScrollPoolLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SpecificSpellScrollPoolLootFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.STRING.listOf().fieldOf("spell_pools").orElse(List.of()).forGetter(f -> f.pools), (App)NumberProviders.CODEC.fieldOf("spell_tier_min").forGetter(f -> f.tierMin), (App)NumberProviders.CODEC.fieldOf("spell_tier_max").forGetter(f -> f.tierMax), (App)NumberProviders.CODEC.fieldOf("count").forGetter(f -> f.count), (App)Codec.STRING.listOf().fieldOf("blacklist_spells").orElse(List.of()).forGetter(f -> f.blacklist))).apply((Applicative)instance, SpecificSpellScrollPoolLootFunction::new));
    public static final LootItemFunctionType<SpecificSpellScrollPoolLootFunction> TYPE = new LootItemFunctionType(CODEC);
    @Nullable
    private final List<String> pools;
    @Nullable
    private final List<String> blacklist;
    private final NumberProvider tierMin;
    private final NumberProvider tierMax;
    @Nullable
    private final NumberProvider count;

    private SpecificSpellScrollPoolLootFunction(List<LootItemCondition> conditions, List<String> pools, NumberProvider tierMin, NumberProvider tierMax, NumberProvider count, List<String> blacklist) {
        super(conditions);
        this.pools = pools;
        this.tierMin = tierMin;
        this.tierMax = tierMax;
        this.count = count;
        this.blacklist = blacklist;
    }

    public LootItemFunctionType<SpecificSpellScrollPoolLootFunction> getType() {
        return TYPE;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of();
    }

    private PoolFilters getPools() {
        if (this.pools == null || this.pools.isEmpty()) {
            return new PoolFilters(List.of(), List.of());
        }
        ArrayList<TagKey<Spell>> tags = new ArrayList<TagKey<Spell>>();
        ArrayList<ResourceLocation> exact = new ArrayList<ResourceLocation>();
        for (String entry : this.pools) {
            if (entry.startsWith("#")) {
                tags.add((TagKey<Spell>)TagKey.create((ResourceKey)SpellRegistry.KEY, (ResourceLocation)ResourceLocation.parse((String)entry.substring(1))));
                continue;
            }
            exact.add(ResourceLocation.parse((String)entry));
        }
        return new PoolFilters(tags, exact);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        SpellContainer.ContentType selectedContentType;
        PoolFilters spellTag = this.getPools();
        int a = this.tierMin.getInt(context);
        int b = this.tierMax.getInt(context);
        int min = Math.min(a, b);
        int max = Math.max(a, b);
        SpellContainer existingContainer = SpellContainerHelper.containerFromItemStack((ItemStack)stack);
        List alreadyPresentSpells = existingContainer != null ? existingContainer.spell_ids().stream().map(ResourceLocation::parse).toList() : List.of();
        PoolFilters poolFilters = this.getPools();
        Set blacklistIds = this.blacklist != null ? this.blacklist.stream().map(ResourceLocation::parse).collect(Collectors.toSet()) : Set.of();
        List<Holder.Reference> spells = SpellRegistry.stream((Level)context.getLevel()).filter(arg_0 -> SpecificSpellScrollPoolLootFunction.lambda$process$6(poolFilters, min, max, blacklistIds, alreadyPresentSpells, arg_0)).toList();
        ArrayList<Holder.Reference> selectedSpells = new ArrayList<Holder.Reference>();
        SpellContainer.ContentType contentType = selectedContentType = existingContainer != null ? existingContainer.content() : null;
        if (!spells.isEmpty()) {
            int selectedCount = this.count != null ? this.count.getInt(context) : 1;
            int retryAttempts = 3;
            for (int i = 0; i < selectedCount; ++i) {
                Holder.Reference entry2 = spells.get(context.getRandom().nextInt(spells.size()));
                while (retryAttempts > 0 && (selectedSpells.contains(entry2) || selectedContentType != null && Objects.equals(SpellContainerHelper.contentTypeForSpell((Spell)((Spell)entry2.value())), selectedContentType))) {
                    entry2 = spells.get(context.getRandom().nextInt(spells.size()));
                    --retryAttempts;
                }
                selectedSpells.add(entry2);
                selectedContentType = SpellContainerHelper.contentTypeForSpell((Spell)((Spell)entry2.value()));
            }
        }
        if (!selectedSpells.isEmpty()) {
            SpellContainer newContainer = existingContainer != null ? existingContainer : SpellContainer.EMPTY.withContentType(selectedContentType != null ? selectedContentType : SpellContainer.ContentType.MAGIC);
            List<String> newSpellIds = selectedSpells.stream().map(entry -> ((ResourceKey)entry.unwrapKey().get()).location().toString()).toList();
            newContainer = newContainer.withAdditionalSpell(newSpellIds);
            List sortedSpellIds = SpellContainerHelper.sortedSpells((Level)context.getLevel(), (List)newContainer.spell_ids());
            newContainer = newContainer.copyWith(sortedSpellIds);
            stack.set(SpellDataComponents.SPELL_CONTAINER, (Object)newContainer);
            if (stack.getItem() == SpellEngineItems.SCROLL.get()) {
                Holder first = (Holder)selectedSpells.get(0);
                ScrollItem.onSpellAdded((ItemStack)stack, (Holder)first, (TagKey)ScrollItem.resolveSpellPool((Level)context.getLevel(), (Holder)first));
            }
        } else if (stack.getItem() == SpellEngineItems.SCROLL.get()) {
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder(List<String> pools, NumberProvider tierMin, NumberProvider tierMax, NumberProvider count, List<String> blacklist) {
        return SpecificSpellScrollPoolLootFunction.simpleBuilder(conditions -> new SpecificSpellScrollPoolLootFunction((List<LootItemCondition>)conditions, pools, tierMin, tierMax, count, blacklist));
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$process$6(PoolFilters poolFilters, int min, int max, Set blacklistIds, List alreadyPresentSpells, Holder.Reference entry) {
        block2: {
            id = ((ResourceKey)entry.unwrapKey().get()).location();
            tier = ((Spell)entry.value()).tier;
            if (!poolFilters.tags().isEmpty()) break block2;
            if (poolFilters.exact().isEmpty()) ** GOTO lbl-1000
        }
        if (poolFilters.tags().stream().anyMatch((Predicate<TagKey>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, is(net.minecraft.tags.TagKey ), (Lnet/minecraft/tags/TagKey;)Z)((Holder.Reference)entry)) || poolFilters.exact().contains(id)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        inPool = v0;
        return tier >= min && tier <= max && inPool != false && blacklistIds.contains(id) == false && alreadyPresentSpells.contains(id) == false;
    }

    private record PoolFilters(List<TagKey<Spell>> tags, List<ResourceLocation> exact) {
    }
}

