/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.entity.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.more_rpg_classes.MRPGCMod;
import net.more_rpg_classes.entity.ISpellCasterEntity;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.utils.TargetHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class CastSpellGoal
extends class_1352 {
    private final ISpellCasterEntity caster;
    private final class_2960 spellId;
    private final List<CastSpellGoal> otherSpellGoals;
    private int spellCooldown = 0;
    private int castingTime = 0;
    private int totalCastTime = 0;
    private boolean isChanneling = false;
    private int channelingInterval = 0;
    private int nextChannelingImpact = 0;

    public CastSpellGoal(ISpellCasterEntity caster, class_2960 spellId) {
        this(caster, spellId, null);
    }

    public CastSpellGoal(ISpellCasterEntity caster, class_2960 spellId, List<CastSpellGoal> otherSpellGoals) {
        this.caster = caster;
        this.spellId = spellId;
        this.otherSpellGoals = otherSpellGoals;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1308 entity = this.caster.asMobEntity();
        class_1309 target = entity.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (this.caster.isSpellcasting()) {
            return false;
        }
        if (this.spellCooldown > 0) {
            return false;
        }
        if (this.otherSpellGoals != null) {
            for (CastSpellGoal otherGoal : this.otherSpellGoals) {
                if (otherGoal == this || !otherGoal.isActive()) continue;
                return false;
            }
        }
        double range = this.caster.getSpellRange(this.spellId);
        double distance = Math.sqrt(entity.method_5858((class_1297)target));
        return distance <= range;
    }

    public boolean method_6266() {
        class_1308 entity = this.caster.asMobEntity();
        class_1309 target = entity.method_5968();
        return target != null && target.method_5805() && this.castingTime > 0;
    }

    public void method_6269() {
        class_6880 spellEntry;
        this.totalCastTime = this.castingTime = this.caster.getCastTime(this.spellId);
        ISpellCasterEntity.SpellType spellType = this.caster.getSpellType(this.spellId);
        ISpellCasterEntity.CastingType castingType = this.caster.getCastingType(this.spellId);
        if (castingType == ISpellCasterEntity.CastingType.CHANNELING) {
            int channelTicks;
            this.isChanneling = true;
            spellEntry = SpellRegistry.from((class_1937)this.caster.asMobEntity().method_37908()).method_55841(this.spellId).orElse(null);
            this.channelingInterval = spellEntry != null && ((Spell)spellEntry.comp_349()).active.cast != null ? ((channelTicks = ((Spell)spellEntry.comp_349()).active.cast.channel_ticks) > 0 ? channelTicks : 20) : 20;
            this.nextChannelingImpact = 0;
        } else {
            this.isChanneling = false;
        }
        this.caster.startSpellCast(this.castingTime);
        spellEntry = SpellRegistry.from((class_1937)this.caster.asMobEntity().method_37908()).method_55841(this.spellId).orElse(null);
        if (spellEntry != null && ((Spell)spellEntry.comp_349()).active.cast != null) {
            ParticleHelper.sendBatches((class_1297)this.caster.asMobEntity(), (ParticleBatch[])((Spell)spellEntry.comp_349()).active.cast.particles);
        }
    }

    public void method_6268() {
        class_1308 entity = this.caster.asMobEntity();
        class_1309 target = entity.method_5968();
        if (target != null) {
            entity.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        }
        --this.castingTime;
        if (this.castingTime % 5 == 0) {
            // empty if block
        }
        if (this.isChanneling) {
            class_6880 spellEntry = SpellRegistry.from((class_1937)entity.method_37908()).method_55841(this.spellId).orElse(null);
            if (spellEntry != null && ((Spell)spellEntry.comp_349()).active.cast != null) {
                ParticleHelper.sendBatches((class_1297)entity, (ParticleBatch[])((Spell)spellEntry.comp_349()).active.cast.particles);
            }
            --this.nextChannelingImpact;
            if (this.nextChannelingImpact <= 0) {
                this.faceTarget(target);
                this.castSpell();
                this.nextChannelingImpact = this.channelingInterval;
            }
        } else if (this.castingTime == this.totalCastTime / 2) {
            this.faceTarget(target);
            this.castSpell();
        }
    }

    private void faceTarget(class_1309 target) {
        class_1308 entity = this.caster.asMobEntity();
        if (target != null) {
            double deltaX = target.method_23317() - entity.method_23317();
            double deltaY = target.method_23320() - entity.method_23320();
            double deltaZ = target.method_23321() - entity.method_23321();
            double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            float targetYaw = (float)(Math.atan2(deltaZ, deltaX) * 57.29577951308232) - 90.0f;
            float targetPitch = (float)(-(Math.atan2(deltaY, horizontalDistance) * 57.29577951308232));
            entity.method_36456(targetYaw);
            entity.method_36457(targetPitch);
            entity.field_6241 = targetYaw;
            entity.field_6283 = targetYaw;
        }
    }

    public void method_6270() {
        this.caster.stopSpellCast();
        this.spellCooldown = this.caster.getSpellCooldown(this.spellId);
        this.castingTime = 0;
        this.totalCastTime = 0;
        this.isChanneling = false;
        this.channelingInterval = 0;
        this.nextChannelingImpact = 0;
    }

    private void castSpell() {
        class_1308 entity = this.caster.asMobEntity();
        if (entity.method_37908().method_8608()) {
            return;
        }
        class_1309 target = entity.method_5968();
        if (target == null) {
            return;
        }
        ISpellCasterEntity.SpellType spellType = this.caster.getSpellType(this.spellId);
        class_6880 spellEntry = SpellRegistry.from((class_1937)entity.method_37908()).method_55841(this.spellId).orElse(null);
        if (spellEntry == null) {
            MRPGCMod.LOGGER.warn("Spell not found: " + String.valueOf(this.spellId));
            return;
        }
        try {
            switch (spellType) {
                case METEOR: {
                    this.castMeteorSpell(target, (class_6880<Spell>)spellEntry);
                    break;
                }
                case PROJECTILE: {
                    this.castProjectileSpell(target, (class_6880<Spell>)spellEntry);
                    break;
                }
                case CLOUD: {
                    this.castCloudSpell(target, (class_6880<Spell>)spellEntry);
                    break;
                }
                case DIRECTIMPACT: {
                    this.castDirectImpactSpell(target, (class_6880<Spell>)spellEntry);
                    break;
                }
                case AREAIMPACT: {
                    this.castAreaImpactSpell(target, (class_6880<Spell>)spellEntry);
                }
            }
        }
        catch (Exception e) {
            MRPGCMod.LOGGER.error("Failed to cast spell " + String.valueOf(this.spellId) + " for spell caster", (Throwable)e);
        }
    }

    private void castMeteorSpell(class_1309 target, class_6880<Spell> spellEntry) {
        class_1308 entity = this.caster.asMobEntity();
        Spell spell = (Spell)spellEntry.comp_349();
        SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)this.caster.getSpellSchool(), (class_1309)entity);
        ISpellCasterEntity.PlacementTarget placementTarget = this.caster.getPlacementTarget(this.spellId);
        class_243 position = placementTarget == ISpellCasterEntity.PlacementTarget.TARGET ? target.method_19538() : entity.method_19538();
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)entity)).position(position).target(SpellTarget.FocusMode.AREA);
        ParticleHelper.sendBatches((class_1297)entity, (ParticleBatch[])spell.release.particles);
        try {
            SpellHelper.fallProjectile((class_1937)entity.method_37908(), (class_1309)entity, (class_1297)target, (class_243)position, spellEntry, (SpellHelper.ImpactContext)context);
        }
        catch (Exception e) {
            SpellHelper.performImpacts((class_1937)entity.method_37908(), (class_1309)entity, (class_1297)target, (class_1297)entity, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)context);
        }
    }

    private void castProjectileSpell(class_1309 target, class_6880<Spell> spellEntry) {
        class_1308 entity = this.caster.asMobEntity();
        Spell spell = (Spell)spellEntry.comp_349();
        SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)this.caster.getSpellSchool(), (class_1309)entity);
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(power).position(entity.method_33571()).target(SpellHelper.focusMode((Spell)spell));
        ParticleHelper.sendBatches((class_1297)entity, (ParticleBatch[])spell.release.particles);
        try {
            SpellHelper.shootProjectile((class_1937)entity.method_37908(), (class_1309)entity, (class_1297)target, spellEntry, (SpellHelper.ImpactContext)context, (int)0);
        }
        catch (Exception e) {
            SpellHelper.performImpacts((class_1937)entity.method_37908(), (class_1309)entity, (class_1297)target, (class_1297)entity, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)context);
        }
    }

    private void castDirectImpactSpell(class_1309 target, class_6880<Spell> spellEntry) {
        class_1308 entity = this.caster.asMobEntity();
        Spell spell = (Spell)spellEntry.comp_349();
        SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)this.caster.getSpellSchool(), (class_1309)entity);
        ParticleHelper.sendBatches((class_1297)entity, (ParticleBatch[])spell.active.cast.particles);
        ParticleHelper.sendBatches((class_1297)entity, (ParticleBatch[])spell.release.particles);
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(power).position(entity.method_33571()).target(SpellHelper.focusMode((Spell)spell));
        SpellHelper.performImpacts((class_1937)entity.method_37908(), (class_1309)entity, (class_1297)target, (class_1297)entity, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)context);
    }

    private void castAreaImpactSpell(class_1309 target, class_6880<Spell> spellEntry) {
        class_1308 entity = this.caster.asMobEntity();
        Spell spell = (Spell)spellEntry.comp_349();
        SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)this.caster.getSpellSchool(), (class_1309)entity);
        if (!entity.method_37908().method_8608() && target != null) {
            ParticleHelper.sendBatches((class_1297)entity, (ParticleBatch[])spell.release.particles);
            ParticleHelper.sendBatches((class_1297)entity, (ParticleBatch[])spell.release.particles_scaled_with_ranged);
            for (class_1297 targetEntity : TargetHelper.targetsFromArea((class_1297)entity, (float)spell.range, (Spell.Target.Area)spell.target.area, e -> e != entity)) {
                SpellHelper.performImpacts((class_1937)entity.method_37908(), (class_1309)entity, (class_1297)targetEntity, (class_1297)entity, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)new SpellHelper.ImpactContext().power(power).position(entity.method_19538()));
                ParticleHelper.sendBatches((class_1297)targetEntity, (ParticleBatch[])((Spell.Impact)spell.impacts.get((int)0)).particles);
            }
        }
    }

    private void castCloudSpell(class_1309 target, class_6880<Spell> spellEntry) {
        class_1308 entity = this.caster.asMobEntity();
        Spell spell = (Spell)spellEntry.comp_349();
        SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)this.caster.getSpellSchool(), (class_1309)entity);
        ISpellCasterEntity.PlacementTarget placementTarget = this.caster.getPlacementTarget(this.spellId);
        class_243 position = placementTarget == ISpellCasterEntity.PlacementTarget.TARGET ? target.method_19538() : entity.method_19538();
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(power).position(entity.method_33571()).target(SpellTarget.FocusMode.AREA);
        ParticleHelper.sendBatches((class_1297)entity, (ParticleBatch[])spell.release.particles);
        SpellHelper.placeCloud((class_1937)entity.method_37908(), (class_1309)entity, (class_1297)target, (class_243)position, spellEntry, (SpellHelper.ImpactContext)context);
    }

    public boolean isActive() {
        return this.castingTime > 0;
    }

    public void updateCooldown() {
        if (this.spellCooldown > 0) {
            --this.spellCooldown;
        }
    }
}

