/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.custom;

import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.more_rpg_classes.entity.attribute.MRPGCEntityAttributes;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.config.AttributesConfig;

public class MoreSpellSchools {
    public static final SpellSchool EARTH = SpellSchools.register((SpellSchool)SpellSchools.createMagic((String)"earth", (int)12421888));
    public static final SpellSchool WATER = SpellSchools.register((SpellSchool)SpellSchools.createMagic((String)"water", (int)5102079));
    public static final SpellSchool AIR = SpellSchools.register((SpellSchool)SpellSchools.createMagic((String)"air", (int)13951998));
    public static final SpellSchool NATURE = SpellSchools.register((SpellSchool)SpellSchools.createMagic((String)"nature", (int)4439883));
    public static final SpellSchool FROST_RANGED = new SpellSchool(SpellSchool.Archetype.ARCHERY, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"frost_ranged"), 0xCCFFFF, DamageTypes.ARROW, MoreSpellSchools.rangedDamageAttribute());
    public static final SpellSchool FIRE_RANGED = new SpellSchool(SpellSchool.Archetype.ARCHERY, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"fire_ranged"), 0xFF3300, DamageTypes.ARROW, MoreSpellSchools.rangedDamageAttribute());
    public static final SpellSchool RAGE_MELEE = new SpellSchool(SpellSchool.Archetype.MELEE, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"rage_melee"), 0xB3B3B3, DamageTypes.PLAYER_ATTACK, Attributes.ATTACK_DAMAGE);

    private static Holder<Attribute> rangedDamageAttribute() {
        if (FabricLoader.getInstance().isModLoaded("ranged_weapon_api")) {
            return EntityAttributes_RangedWeapon.DAMAGE.entry;
        }
        return Attributes.ATTACK_DAMAGE;
    }

    public static void initialize() {
        SpellSchools.register((SpellSchool)EARTH);
        SpellSchools.register((SpellSchool)WATER);
        SpellSchools.register((SpellSchool)AIR);
        SpellSchools.register((SpellSchool)NATURE);
        FROST_RANGED.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> {
            double second_power = query.entity().getAttributeValue(SpellSchools.FROST.attributeEntry);
            return query.entity().getAttributeValue(MoreSpellSchools.rangedDamageAttribute()) + second_power;
        });
        FIRE_RANGED.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> {
            double second_power = query.entity().getAttributeValue(SpellSchools.FIRE.attributeEntry);
            return query.entity().getAttributeValue(MoreSpellSchools.rangedDamageAttribute()) + second_power;
        });
        SpellSchools.register((SpellSchool)FROST_RANGED);
        SpellSchools.register((SpellSchool)FIRE_RANGED);
        if (FabricLoader.getInstance().isModLoaded("ranged_weapon_api")) {
            FIRE_RANGED.addSource(SpellSchool.Trait.HASTE, SpellSchool.Apply.ADD, query -> {
                double haste = query.entity().getAttributeValue(EntityAttributes_RangedWeapon.HASTE.entry);
                double rate = EntityAttributes_RangedWeapon.HASTE.asMultiplier(haste);
                return rate - 1.0;
            });
            FROST_RANGED.addSource(SpellSchool.Trait.HASTE, SpellSchool.Apply.ADD, query -> {
                double haste = query.entity().getAttributeValue(EntityAttributes_RangedWeapon.HASTE.entry);
                double rate = EntityAttributes_RangedWeapon.HASTE.asMultiplier(haste);
                return rate - 1.0;
            });
            SpellSchools.configureSpellHaste((SpellSchool)FROST_RANGED);
            SpellSchools.configureSpellHaste((SpellSchool)FIRE_RANGED);
        }
        RAGE_MELEE.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> query.entity().getAttributeValue(Attributes.ATTACK_DAMAGE) + (query.entity().getAttributeValue(MRPGCEntityAttributes.RAGE_MODIFIER) - 100.0) / 50.0);
        RAGE_MELEE.addSource(SpellSchool.Trait.CRIT_CHANCE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_chance_percentage + query.entity().getAttributeValue(MRPGCEntityAttributes.RAGE_MODIFIER) - 10.0;
            return value / 100.0 - 1.0;
        }));
        RAGE_MELEE.addSource(SpellSchool.Trait.CRIT_DAMAGE, new SpellSchool.Source(SpellSchool.Apply.ADD, query -> {
            double value = ((AttributesConfig)SpellPowerMod.attributesConfig.value).base_spell_critical_damage_percentage + query.entity().getAttributeValue(MRPGCEntityAttributes.RAGE_MODIFIER) - 25.0;
            return value / 100.0 - 1.0;
        }));
        SpellSchools.configureSpellCritDamage((SpellSchool)RAGE_MELEE);
        SpellSchools.configureSpellCritChance((SpellSchool)RAGE_MELEE);
        SpellSchools.configureSpellHaste((SpellSchool)RAGE_MELEE);
        SpellSchools.register((SpellSchool)RAGE_MELEE);
    }
}

