/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.effect;

import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.more_rpg_classes.MRPGCMod;
import net.more_rpg_classes.config.EffectsConfig;
import net.more_rpg_classes.effect.MRPGCEffects;

public class FrostedEffect
extends MobEffect {
    public FrostedEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        super.onEffectStarted(livingEntity, amplifier);
        EntityType type = livingEntity.getType();
        if (!type.is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES)) {
            if (!livingEntity.hasEffect(MRPGCEffects.FROZEN_SOLID.registryEntry)) {
                if (amplifier == ((EffectsConfig)MRPGCMod.effectsConfig.value).frosted_amplifier_frozen_solid_conversion) {
                    livingEntity.addEffect(new MobEffectInstance(MRPGCEffects.FROZEN_SOLID.registryEntry, 100, 0, false, false, true));
                    livingEntity.removeEffect(MRPGCEffects.FROSTED.registryEntry);
                }
            } else {
                livingEntity.removeEffect(MRPGCEffects.FROSTED.registryEntry);
            }
        } else {
            livingEntity.removeEffect(MRPGCEffects.FROSTED.registryEntry);
        }
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int pAmplifier) {
        if (livingEntity.isOnFire() || livingEntity.isInLava()) {
            return livingEntity.removeEffect(MRPGCEffects.FROSTED.registryEntry);
        }
        super.applyEffectTick(livingEntity, pAmplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

