/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.util.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_120;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.item.ScrollItem;
import net.spell_engine.item.SpellEngineItems;
import org.jetbrains.annotations.Nullable;

public class SpecificSpellScrollPoolLootFunction
extends class_120 {
    public static final String NAME = "specific_spell_scroll_pool";
    public static final class_2960 ID = class_2960.method_60655((String)"more_rpg_classes", (String)"specific_spell_scroll_pool");
    public static final MapCodec<SpecificSpellScrollPoolLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SpecificSpellScrollPoolLootFunction.method_53344((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.STRING.listOf().fieldOf("spell_pools").orElse(List.of()).forGetter(f -> f.pools), (App)class_5659.field_45888.fieldOf("spell_tier_min").forGetter(f -> f.tierMin), (App)class_5659.field_45888.fieldOf("spell_tier_max").forGetter(f -> f.tierMax), (App)class_5659.field_45888.fieldOf("count").forGetter(f -> f.count), (App)Codec.STRING.listOf().fieldOf("blacklist_spells").orElse(List.of()).forGetter(f -> f.blacklist))).apply((Applicative)instance, SpecificSpellScrollPoolLootFunction::new));
    public static final class_5339<SpecificSpellScrollPoolLootFunction> TYPE = new class_5339(CODEC);
    @Nullable
    private final List<String> pools;
    @Nullable
    private final List<String> blacklist;
    private final class_5658 tierMin;
    private final class_5658 tierMax;
    @Nullable
    private final class_5658 count;

    private SpecificSpellScrollPoolLootFunction(List<class_5341> conditions, List<String> pools, class_5658 tierMin, class_5658 tierMax, class_5658 count, List<String> blacklist) {
        super(conditions);
        this.pools = pools;
        this.tierMin = tierMin;
        this.tierMax = tierMax;
        this.count = count;
        this.blacklist = blacklist;
    }

    public class_5339<SpecificSpellScrollPoolLootFunction> method_29321() {
        return TYPE;
    }

    public Set<class_169<?>> method_293() {
        return Set.of();
    }

    private PoolFilters getPools() {
        if (this.pools == null || this.pools.isEmpty()) {
            return new PoolFilters(List.of(), List.of());
        }
        ArrayList<class_6862<Spell>> tags = new ArrayList<class_6862<Spell>>();
        ArrayList<class_2960> exact = new ArrayList<class_2960>();
        for (String entry : this.pools) {
            if (entry.startsWith("#")) {
                tags.add((class_6862<Spell>)class_6862.method_40092((class_5321)SpellRegistry.KEY, (class_2960)class_2960.method_60654((String)entry.substring(1))));
                continue;
            }
            exact.add(class_2960.method_60654((String)entry));
        }
        return new PoolFilters(tags, exact);
    }

    public class_1799 method_522(class_1799 stack, class_47 context) {
        SpellContainer.ContentType selectedContentType;
        PoolFilters spellTag = this.getPools();
        int a = this.tierMin.method_366(context);
        int b = this.tierMax.method_366(context);
        int min = Math.min(a, b);
        int max = Math.max(a, b);
        SpellContainer existingContainer = SpellContainerHelper.containerFromItemStack((class_1799)stack);
        List alreadyPresentSpells = existingContainer != null ? existingContainer.spell_ids().stream().map(class_2960::method_60654).toList() : List.of();
        PoolFilters poolFilters = this.getPools();
        Set blacklistIds = this.blacklist != null ? this.blacklist.stream().map(class_2960::method_60654).collect(Collectors.toSet()) : Set.of();
        List<class_6880.class_6883> spells = SpellRegistry.stream((class_1937)context.method_299()).filter(arg_0 -> SpecificSpellScrollPoolLootFunction.lambda$process$6(poolFilters, min, max, blacklistIds, alreadyPresentSpells, arg_0)).toList();
        ArrayList<class_6880.class_6883> selectedSpells = new ArrayList<class_6880.class_6883>();
        SpellContainer.ContentType contentType = selectedContentType = existingContainer != null ? existingContainer.content() : null;
        if (!spells.isEmpty()) {
            int selectedCount = this.count != null ? this.count.method_366(context) : 1;
            int retryAttempts = 3;
            for (int i = 0; i < selectedCount; ++i) {
                class_6880.class_6883 entry2 = spells.get(context.method_294().method_43048(spells.size()));
                while (retryAttempts > 0 && (selectedSpells.contains(entry2) || selectedContentType != null && Objects.equals(SpellContainerHelper.contentTypeForSpell((Spell)((Spell)entry2.comp_349())), selectedContentType))) {
                    entry2 = spells.get(context.method_294().method_43048(spells.size()));
                    --retryAttempts;
                }
                selectedSpells.add(entry2);
                selectedContentType = SpellContainerHelper.contentTypeForSpell((Spell)((Spell)entry2.comp_349()));
            }
        }
        if (!selectedSpells.isEmpty()) {
            SpellContainer newContainer = existingContainer != null ? existingContainer : SpellContainer.EMPTY.withContentType(selectedContentType != null ? selectedContentType : SpellContainer.ContentType.MAGIC);
            List<String> newSpellIds = selectedSpells.stream().map(entry -> ((class_5321)entry.method_40230().get()).method_29177().toString()).toList();
            newContainer = newContainer.withAdditionalSpell(newSpellIds);
            List sortedSpellIds = SpellContainerHelper.sortedSpells((class_1937)context.method_299(), (List)newContainer.spell_ids());
            newContainer = newContainer.copyWith(sortedSpellIds);
            stack.method_57379(SpellDataComponents.SPELL_CONTAINER, (Object)newContainer);
            if (stack.method_7909() == SpellEngineItems.SCROLL.method_15332()) {
                class_6880 first = (class_6880)selectedSpells.get(0);
                ScrollItem.onSpellAdded((class_1799)stack, (class_6880)first, (class_6862)ScrollItem.resolveSpellPool((class_1937)context.method_299(), (class_6880)first));
            }
        } else if (stack.method_7909() == SpellEngineItems.SCROLL.method_15332()) {
            return class_1799.field_8037;
        }
        return stack;
    }

    public static class_120.class_121<?> builder(List<String> pools, class_5658 tierMin, class_5658 tierMax, class_5658 count, List<String> blacklist) {
        return SpecificSpellScrollPoolLootFunction.method_520(conditions -> new SpecificSpellScrollPoolLootFunction((List<class_5341>)conditions, pools, tierMin, tierMax, count, blacklist));
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$process$6(PoolFilters poolFilters, int min, int max, Set blacklistIds, List alreadyPresentSpells, class_6880.class_6883 entry) {
        block2: {
            id = ((class_5321)entry.method_40230().get()).method_29177();
            tier = ((Spell)entry.comp_349()).tier;
            if (!poolFilters.tags().isEmpty()) break block2;
            if (poolFilters.exact().isEmpty()) ** GOTO lbl-1000
        }
        if (poolFilters.tags().stream().anyMatch((Predicate<class_6862>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, method_40220(net.minecraft.class_6862 ), (Lnet/minecraft/class_6862;)Z)((class_6880.class_6883)entry)) || poolFilters.exact().contains(id)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        inPool = v0;
        return tier >= min && tier <= max && inPool != false && blacklistIds.contains(id) == false && alreadyPresentSpells.contains(id) == false;
    }

    private record PoolFilters(List<class_6862<Spell>> tags, List<class_2960> exact) {
    }
}

