/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.util.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.class_120;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;

public class BindSpellFromPoolsLootFunction
extends class_120 {
    public static final String NAME = "bind_spell_from_pools";
    public static final class_2960 ID = class_2960.method_60655((String)"more_rpg_classes", (String)"bind_spell_from_pools");
    private final class_5658 chance;
    public static final MapCodec<BindSpellFromPoolsLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> BindSpellFromPoolsLootFunction.method_53344((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.STRING.listOf().fieldOf("spell_pools").orElse(List.of()).forGetter(f -> f.pools), (App)class_5659.field_45888.fieldOf("count").orElse((Object)class_44.method_32448((float)1.0f)).forGetter(f -> f.count), (App)class_5659.field_45888.optionalFieldOf("chance").forGetter(f -> Optional.ofNullable(f.chance)))).apply((Applicative)instance, BindSpellFromPoolsLootFunction::new));
    public static final class_5339<BindSpellFromPoolsLootFunction> TYPE = new class_5339(CODEC);
    private final List<String> pools;
    private final class_5658 count;

    public BindSpellFromPoolsLootFunction(List<class_5341> conditions, List<String> pools, class_5658 count, Optional<class_5658> chance) {
        super(conditions);
        this.pools = pools;
        this.count = count;
        this.chance = chance.orElse(null);
    }

    public class_5339<BindSpellFromPoolsLootFunction> method_29321() {
        return TYPE;
    }

    public Set<class_169<?>> method_293() {
        return Set.of();
    }

    private PoolFilters getPools() {
        if (this.pools == null || this.pools.isEmpty()) {
            return new PoolFilters(List.of(), List.of());
        }
        ArrayList<class_6862<Spell>> tags = new ArrayList<class_6862<Spell>>();
        ArrayList<class_2960> exact = new ArrayList<class_2960>();
        for (String entry : this.pools) {
            if (entry.startsWith("#")) {
                class_2960 id = class_2960.method_60654((String)entry.substring(1));
                tags.add((class_6862<Spell>)class_6862.method_40092((class_5321)SpellRegistry.KEY, (class_2960)id));
                continue;
            }
            exact.add(class_2960.method_60654((String)entry));
        }
        return new PoolFilters(tags, exact);
    }

    public class_1799 method_522(class_1799 stack, class_47 context) {
        if (this.chance != null && context.method_294().method_43057() >= this.chance.method_32454(context)) {
            return stack;
        }
        SpellContainer existing = SpellContainerHelper.containerFromItemStack((class_1799)stack);
        if (existing == null) {
            existing = SpellContainer.EMPTY;
        }
        List<class_2960> alreadyPresentSpells = existing.spell_ids().stream().map(class_2960::method_60654).toList();
        PoolFilters poolFilters = this.getPools();
        List<class_6880.class_6883> poolSpells = SpellRegistry.stream((class_1937)context.method_299()).filter(entry -> {
            class_2960 id;
            block5: {
                block4: {
                    id = ((class_5321)entry.method_40230().get()).method_29177();
                    if (!poolFilters.tags().isEmpty()) break block4;
                    if (poolFilters.exact().isEmpty()) break block5;
                }
                if (!poolFilters.tags().stream().anyMatch(arg_0 -> ((class_6880.class_6883)entry).method_40220(arg_0))) {
                    if (!poolFilters.exact().contains(id)) return false;
                }
            }
            boolean bl = true;
            boolean inPool = bl;
            if (!inPool) return false;
            if (alreadyPresentSpells.contains(id)) return false;
            return true;
        }).toList();
        if (poolSpells.isEmpty()) {
            return stack;
        }
        int selectedCount = this.count.method_366(context);
        if (selectedCount < 1) {
            selectedCount = 1;
        }
        class_5819 random = context.method_294();
        ArrayList<class_6880> selected = new ArrayList<class_6880>();
        SpellContainer.ContentType contentType = existing.content();
        for (int i = 0; i < selectedCount; ++i) {
            class_6880 entry2 = (class_6880)poolSpells.get(random.method_43048(poolSpells.size()));
            for (int attempts = 3; attempts > 0 && (selected.contains(entry2) || contentType != null && Objects.equals(SpellContainerHelper.contentTypeForSpell((Spell)((Spell)entry2.comp_349())), contentType)); --attempts) {
                entry2 = (class_6880)poolSpells.get(random.method_43048(poolSpells.size()));
            }
            selected.add(entry2);
            contentType = SpellContainerHelper.contentTypeForSpell((Spell)((Spell)entry2.comp_349()));
        }
        SpellContainer container = existing.withContentType(contentType != null ? contentType : SpellContainer.ContentType.MAGIC);
        List<String> newSpellIds = selected.stream().map(e -> ((class_5321)e.method_40230().get()).method_29177().toString()).toList();
        container = container.withAdditionalSpell(newSpellIds);
        List sorted = SpellContainerHelper.sortedSpells((class_1937)context.method_299(), (List)container.spell_ids());
        container = container.copyWith(sorted);
        stack.method_57379(SpellDataComponents.SPELL_CONTAINER, (Object)container);
        return stack;
    }

    public static class_120.class_121<?> builder(List<String> pools, class_5658 count, @Nullable class_5658 chance) {
        return BindSpellFromPoolsLootFunction.method_520(conditions -> new BindSpellFromPoolsLootFunction((List<class_5341>)conditions, pools, count, Optional.ofNullable(chance)));
    }

    private record PoolFilters(List<class_6862<Spell>> tags, List<class_2960> exact) {
    }
}

