/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.compat.armory_rpgs;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import net.armory_rpgs.item.Group;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.more_rpg_classes.compat.armory_rpgs.FightClass;

public class SmithingIngredients {
    public static final ArrayList<Entry> ENTRIES = new ArrayList();
    public static Entry WARDEN;
    public static Entry ASCETIC;
    public static Entry RAVAGER;
    public static Entry GENERAL;
    public static Entry VIRTUOSO;
    public static final boolean devEnvo;
    public static final boolean archersExpansionLoaded;
    public static final boolean elementalWizardsLoaded;
    public static final boolean berserkerLoaded;
    public static final boolean forcemasterLoaded;

    public static Entry add(Entry entry) {
        ENTRIES.add(entry);
        return entry;
    }

    public static void register() {
        if (devEnvo || forcemasterLoaded) {
            ASCETIC = SmithingIngredients.add(Entry.of("ascetic", List.of(FightClass.AIR_WIZARD, FightClass.FORCEMASTER), new Translations("Ascetic's Lost Crystal")));
        }
        for (Entry entry : ENTRIES) {
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)((Object)entry.item().get()));
        }
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)Group.KEY).register(content -> {
            for (Entry entry : ENTRIES) {
                content.accept((ItemLike)entry.item().get());
            }
        });
    }

    static {
        devEnvo = FabricLoader.getInstance().isDevelopmentEnvironment();
        archersExpansionLoaded = FabricLoader.getInstance().isModLoaded("archers_expansion");
        elementalWizardsLoaded = FabricLoader.getInstance().isModLoaded("elemental_wizards_rpg");
        berserkerLoaded = FabricLoader.getInstance().isModLoaded("berserker_rpg");
        forcemasterLoaded = FabricLoader.getInstance().isModLoaded("forcemaster_rpg");
    }

    public record Translations(String itemName) {
    }

    public record Entry(String name, List<FightClass> classes, Translations translations, java.util.function.Supplier<UpgradeCrystal> item) {
        public static Entry of(String name, List<FightClass> classes, Translations translations) {
            Supplier factory = Suppliers.memoize(() -> new UpgradeCrystal(new Item.Properties().rarity(Rarity.EPIC).fireResistant(), Entry.appliesToTranslationKey(name)));
            return new Entry(name, classes, translations, (java.util.function.Supplier<UpgradeCrystal>)factory);
        }

        public ResourceLocation id() {
            return ResourceLocation.fromNamespaceAndPath((String)"more_rpg_classes", (String)(this.name + "_upgrade_crystal"));
        }

        public static String appliesToTranslationKey(String name) {
            return Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"more_rpg_classes", (String)("upgrade_crystal." + name + ".applies_to")));
        }

        public String appliesToTranslationKey() {
            return Entry.appliesToTranslationKey(this.name);
        }

        public String appliesToClassesTranslation() {
            List<String> classNames = this.classes.stream().map(c -> c.translation).toList();
            Object list = "";
            if (classNames.size() == 1) {
                list = classNames.get(0);
            } else if (classNames.size() == 2) {
                list = classNames.get(0) + " and " + classNames.get(1);
            } else {
                List<String> allButLast = classNames.subList(0, classNames.size() - 1);
                String last = classNames.get(classNames.size() - 1);
                list = String.join((CharSequence)", ", allButLast) + ", and " + last;
            }
            return (String)list + " armor";
        }
    }

    public static class UpgradeCrystal
    extends Item {
        public static final Component APPLIES_TO_TEXT = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"smithing_template.applies_to"))).withStyle(ChatFormatting.GRAY);
        public static final String HINT_TRANSLATION_KEY = Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)"smithing_template.hint"));
        public static final Component HINT_TEXT = Component.translatable((String)HINT_TRANSLATION_KEY).withStyle(ChatFormatting.GRAY);
        private final String appliesToTranslationKey;

        public UpgradeCrystal(Item.Properties settings, String appliesToTranslationKey) {
            super(settings);
            this.appliesToTranslationKey = appliesToTranslationKey;
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
            super.appendHoverText(stack, context, tooltip, type);
            tooltip.add(HINT_TEXT);
            tooltip.add(CommonComponents.EMPTY);
            tooltip.add(APPLIES_TO_TEXT);
            tooltip.add((Component)CommonComponents.space().append((Component)Component.translatable((String)this.appliesToTranslationKey)).withStyle(ChatFormatting.BLUE));
        }
    }
}

