/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.custom.spell_impacts;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.more_rpg_classes.MRPGCMod;
import net.more_rpg_classes.config.TweaksConfig;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.event.SpellHandlers;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellDamageSource;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class DamageToMissingHealthSpellImpact
implements SpellHandlers.CustomImpact {
    public SpellHandlers.ImpactResult onSpellImpact(Holder<Spell> spell, SpellPower.Result powerResult, LivingEntity caster, Entity target, SpellHelper.ImpactContext context) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            float missinghealth = (livingEntity.getHealth() - livingEntity.getMaxHealth()) / livingEntity.getMaxHealth();
            float damageMultiplier = ((TweaksConfig)MRPGCMod.tweaksConfig.value).custom_spell_impact_damage_to_missing_health_above_50;
            if (missinghealth >= 0.5f) {
                damageMultiplier = ((TweaksConfig)MRPGCMod.tweaksConfig.value).custom_spell_impact_damage_to_missing_health_under_50;
            } else if (missinghealth >= 0.25f) {
                damageMultiplier = ((TweaksConfig)MRPGCMod.tweaksConfig.value).custom_spell_impact_damage_to_missing_health_under_25;
            }
            float schoolAttributeValue = (float)caster.getAttributeValue(((Spell)spell.value()).school.attributeEntry);
            livingEntity.invulnerableTime = 0;
            livingEntity.hurt(SpellDamageSource.create((SpellSchool)((Spell)spell.value()).school, (LivingEntity)caster), schoolAttributeValue * damageMultiplier);
        }
        return new SpellHandlers.ImpactResult(true, false);
    }
}

