/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.effect;

import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.more_rpg_classes.damage.BleedingDamageSource;
import net.more_rpg_classes.effect.MRPGCEffects;
import net.more_rpg_classes.util.tags.MRPGCEntityTags;

public class BleedingEffect
extends MobEffect {
    protected BleedingEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        EntityType type = entity.getType();
        if (type.is(MRPGCEntityTags.BLEEDING_IMMUNE)) {
            entity.removeEffect(MRPGCEffects.BLEEDING.registryEntry);
        }
        float bleedingTickDamage = 1.0f;
        float currentHealthPercentage = entity.getHealth() / entity.getMaxHealth();
        if (currentHealthPercentage <= 0.75f) {
            bleedingTickDamage += entity.getMaxHealth() * 0.01f;
        }
        if (currentHealthPercentage <= 0.5f) {
            bleedingTickDamage += entity.getMaxHealth() * 0.025f;
        }
        if (currentHealthPercentage <= 0.25f) {
            bleedingTickDamage += entity.getMaxHealth() * 0.05f;
        }
        entity.invulnerableTime = 0;
        entity.hurt((DamageSource)new BleedingDamageSource((Holder<DamageType>)entity.damageSources().starve().typeHolder()), bleedingTickDamage);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int interval = 40 >> amplifier;
        if (interval < 20) {
            interval = 20;
        }
        return duration % interval == 0;
    }
}

