/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.rpgenchanting.block.entitiy;

import com.github.theredbrain.rpgenchanting.RPGEnchanting;
import com.github.theredbrain.rpgenchanting.block.RPGEnchantingTableBlock;
import com.github.theredbrain.rpgenchanting.config.ServerConfig;
import com.github.theredbrain.rpgenchanting.registry.EntityRegistry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7714;
import net.minecraft.class_7716;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import net.minecraft.class_8781;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

public class RPGEnchantingTableBlockEntity
extends class_2586
implements class_1275 {
    public int ticks;
    public float nextPageAngle;
    public float pageAngle;
    public float flipRandom;
    public float flipTurn;
    public float nextPageTurningSpeed;
    public float pageTurningSpeed;
    public float bookRotation;
    public float lastBookRotation;
    public float targetBookRotation;
    private static final class_5819 RANDOM = class_5819.method_43047();
    @Nullable
    private RPGEnchantingTableBlock.BookCost customBookCost;
    @Nullable
    private RPGEnchantingTableBlock.EnchantmentUnlockMode customEnchantmentUnlockMode;
    @Nullable
    private class_2561 customName;
    private int customBlockReachRadius = -1;

    public RPGEnchantingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityRegistry.RPG_ENCHANTING_TABLE, pos, state);
    }

    public HashSet<MutablePair<String, Integer>> getAdvancementEnchantments(class_1657 playerEntity) {
        HashSet<MutablePair<String, Integer>> advancement_enchantments = new HashSet<MutablePair<String, Integer>>();
        if (this.field_11863 != null) {
            MinecraftServer server = this.field_11863.method_8503();
            ValidatedList<ServerConfig.UnlockedEnchantment> enchantments_unlocked_by_advancements = RPGEnchanting.SERVER_CONFIG.enchantments_unlocked_by_advancements;
            if (enchantments_unlocked_by_advancements.isEmpty()) {
                return advancement_enchantments;
            }
            if (playerEntity instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)playerEntity;
                if (server != null) {
                    for (ServerConfig.UnlockedEnchantment unlockedEnchantment : enchantments_unlocked_by_advancements) {
                        Optional optionalEnchantmentReference;
                        class_8781 placedAdvancement = server.method_3851().method_53646().method_716(class_2960.method_60654((String)unlockedEnchantment.identifier));
                        if (placedAdvancement == null) continue;
                        class_8779 advancementEntry = placedAdvancement.method_53649();
                        if (!serverPlayerEntity.method_14236().method_12882(advancementEntry).method_740() || !(optionalEnchantmentReference = this.field_11863.method_30349().method_30530(class_7924.field_41265).method_55841(class_2960.method_60654((String)unlockedEnchantment.enchantment))).isPresent()) continue;
                        advancement_enchantments.add((MutablePair<String, Integer>)new MutablePair((Object)((class_6880.class_6883)optionalEnchantmentReference.get()).method_55840(), (Object)unlockedEnchantment.level));
                    }
                }
            }
        }
        return advancement_enchantments;
    }

    public HashSet<MutablePair<String, Integer>> getBlockEnchantments() {
        HashSet<MutablePair<String, Integer>> block_enchantments = new HashSet<MutablePair<String, Integer>>();
        ServerConfig serverConfig = RPGEnchanting.SERVER_CONFIG;
        ValidatedList<ServerConfig.UnlockedEnchantment> enchantments_unlocked_by_blocks = serverConfig.enchantments_unlocked_by_blocks;
        if (enchantments_unlocked_by_blocks.isEmpty()) {
            return block_enchantments;
        }
        int rpg_enchanting_table_block_reach_radius = this.getBlockReachRadius();
        HashMap blockMap = new HashMap();
        for (ServerConfig.UnlockedEnchantment unlockedEnchantment : enchantments_unlocked_by_blocks) {
            class_6880.class_6883 registryBlockEntry = null;
            Optional optionalBlock = class_7923.field_41175.method_55841(class_2960.method_60654((String)unlockedEnchantment.identifier));
            if (optionalBlock.isPresent()) {
                registryBlockEntry = (class_6880.class_6883)optionalBlock.get();
            }
            Optional optionalEnchantmentReference = this.field_11863.method_30349().method_30530(class_7924.field_41265).method_55841(class_2960.method_60654((String)unlockedEnchantment.enchantment));
            if (registryBlockEntry == null || !optionalEnchantmentReference.isPresent()) continue;
            HashSet<MutablePair> arrayList = blockMap.getOrDefault(registryBlockEntry.comp_349(), new HashSet());
            arrayList.add(new MutablePair((Object)((class_6880.class_6883)optionalEnchantmentReference.get()), (Object)unlockedEnchantment.level));
            blockMap.put((class_2248)registryBlockEntry.comp_349(), arrayList);
        }
        if (blockMap.isEmpty()) {
            return block_enchantments;
        }
        int posX = this.field_11867.method_10263();
        int posY = this.field_11867.method_10264();
        int posZ = this.field_11867.method_10260();
        for (int i = -rpg_enchanting_table_block_reach_radius; i <= rpg_enchanting_table_block_reach_radius; ++i) {
            for (int j = -rpg_enchanting_table_block_reach_radius; j <= rpg_enchanting_table_block_reach_radius; ++j) {
                for (int k = -rpg_enchanting_table_block_reach_radius; k <= rpg_enchanting_table_block_reach_radius; ++k) {
                    class_2338 blockPos = new class_2338(posX + i, posY + j, posZ + k);
                    class_2680 blockState = this.field_11863.method_8320(blockPos);
                    class_2248 block = blockState.method_26204();
                    Set set = (Set)blockMap.get(block);
                    if (set != null) {
                        for (MutablePair pair : set) {
                            block_enchantments.add((MutablePair<String, Integer>)new MutablePair((Object)((class_6880.class_6883)pair.getLeft()).method_55840(), (Object)((Integer)pair.getRight())));
                        }
                        blockMap.remove(block);
                    }
                    if (blockMap.isEmpty()) break;
                }
                if (blockMap.isEmpty()) break;
            }
            if (blockMap.isEmpty()) break;
        }
        return block_enchantments;
    }

    public HashSet<MutablePair<String, Integer>> getBookEnchantments() {
        HashSet<MutablePair<String, Integer>> book_enchantments = new HashSet<MutablePair<String, Integer>>();
        ServerConfig serverConfig = RPGEnchanting.SERVER_CONFIG;
        if (!((Boolean)serverConfig.enable_enchantment_unlocking_by_chiseled_bookshelves.get()).booleanValue()) {
            return book_enchantments;
        }
        int posX = this.field_11867.method_10263();
        int posY = this.field_11867.method_10264();
        int posZ = this.field_11867.method_10260();
        int rpg_enchanting_table_block_reach_radius = this.getBlockReachRadius();
        for (int i = -rpg_enchanting_table_block_reach_radius; i <= rpg_enchanting_table_block_reach_radius; ++i) {
            for (int j = -rpg_enchanting_table_block_reach_radius; j <= rpg_enchanting_table_block_reach_radius; ++j) {
                for (int k = -rpg_enchanting_table_block_reach_radius; k <= rpg_enchanting_table_block_reach_radius; ++k) {
                    class_2586 blockEntity;
                    class_2338 blockPos = new class_2338(posX + i, posY + j, posZ + k);
                    class_2680 blockState = this.field_11863.method_8320(blockPos);
                    if (!(blockState.method_26204() instanceof class_7714) || !((blockEntity = this.field_11863.method_8321(blockPos)) instanceof class_7716)) continue;
                    class_7716 chiseledBookshelfBlockEntity = (class_7716)blockEntity;
                    for (int l = 0; l < 6; ++l) {
                        class_1799 itemStack = chiseledBookshelfBlockEntity.method_5438(l);
                        class_9304 itemEnchantmentsComponent = (class_9304)itemStack.method_57824(class_9334.field_49643);
                        if (itemEnchantmentsComponent == null) continue;
                        for (Object2IntMap.Entry entry : itemEnchantmentsComponent.method_57539()) {
                            book_enchantments.add((MutablePair<String, Integer>)new MutablePair((Object)((class_6880)entry.getKey()).method_55840(), (Object)entry.getIntValue()));
                        }
                    }
                }
            }
        }
        return book_enchantments;
    }

    public RPGEnchantingTableBlock.BookCost getBookCost() {
        return this.customBookCost != null ? this.customBookCost : (RPGEnchantingTableBlock.BookCost)((Object)RPGEnchanting.SERVER_CONFIG.default_book_cost.get());
    }

    public RPGEnchantingTableBlock.EnchantmentUnlockMode getEnchantingMode() {
        return this.customEnchantmentUnlockMode != null ? this.customEnchantmentUnlockMode : (RPGEnchantingTableBlock.EnchantmentUnlockMode)((Object)RPGEnchanting.SERVER_CONFIG.default_enchantment_unlock_mode.get());
    }

    public int getBlockReachRadius() {
        return this.customBlockReachRadius >= 0 ? this.customBlockReachRadius : (Integer)RPGEnchanting.SERVER_CONFIG.rpg_enchanting_table_block_reach_radius.get();
    }

    public boolean applyBookCost(MutablePair<class_6880.class_6883<class_1887>, Integer> enchantment) {
        ServerConfig serverConfig = RPGEnchanting.SERVER_CONFIG;
        int posX = this.field_11867.method_10263();
        int posY = this.field_11867.method_10264();
        int posZ = this.field_11867.method_10260();
        int rpg_enchanting_table_block_reach_radius = this.getBlockReachRadius();
        RPGEnchantingTableBlock.BookCost bookCost = this.getBookCost();
        if (bookCost == RPGEnchantingTableBlock.BookCost.KEEP) {
            return true;
        }
        if (this.field_11863 != null) {
            for (int i = -rpg_enchanting_table_block_reach_radius; i <= rpg_enchanting_table_block_reach_radius; ++i) {
                for (int j = -rpg_enchanting_table_block_reach_radius; j <= rpg_enchanting_table_block_reach_radius; ++j) {
                    for (int k = -rpg_enchanting_table_block_reach_radius; k <= rpg_enchanting_table_block_reach_radius; ++k) {
                        class_2586 blockEntity;
                        class_2338 blockPos = new class_2338(posX + i, posY + j, posZ + k);
                        class_2680 blockState = this.field_11863.method_8320(blockPos);
                        if (!(blockState.method_26204() instanceof class_7714) || !((blockEntity = this.field_11863.method_8321(blockPos)) instanceof class_7716)) continue;
                        class_7716 chiseledBookshelfBlockEntity = (class_7716)blockEntity;
                        for (int l = 0; l < 6; ++l) {
                            class_1799 newStack;
                            class_1799 itemStack = chiseledBookshelfBlockEntity.method_5438(l);
                            class_9304 itemEnchantmentsComponent = (class_9304)itemStack.method_57824(class_9334.field_49643);
                            boolean replaceBook = false;
                            if (itemEnchantmentsComponent != null) {
                                for (Object2IntMap.Entry entry : itemEnchantmentsComponent.method_57539()) {
                                    if (entry.getKey() != enchantment.getLeft() || entry.getIntValue() != ((Integer)enchantment.getRight()).intValue()) continue;
                                    replaceBook = true;
                                }
                            }
                            if (!replaceBook) continue;
                            class_9304.class_9305 builder = new class_9304.class_9305(itemEnchantmentsComponent);
                            builder.method_57547((class_6880)enchantment.getLeft(), 0);
                            if (bookCost == RPGEnchantingTableBlock.BookCost.CONSUME || builder.method_57545().isEmpty()) {
                                newStack = new class_1799((class_1935)class_7923.field_41178.method_10223((class_2960)serverConfig.enchanted_book_replacement.get()));
                            } else {
                                newStack = itemStack.method_7972();
                                newStack.method_57379(class_9334.field_49643, (Object)builder.method_57549());
                            }
                            chiseledBookshelfBlockEntity.method_5447(l, newStack);
                            chiseledBookshelfBlockEntity.method_5431();
                            this.field_11863.method_8413(blockPos, blockState, blockState, 3);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (this.method_16914()) {
            nbt.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName, (class_7225.class_7874)registryLookup));
        }
        if (this.customBookCost != null) {
            nbt.method_10582("custom_book_cost", this.customBookCost.method_15434());
        }
        if (this.customEnchantmentUnlockMode != null) {
            nbt.method_10582("custom_enchanting_mode", this.customEnchantmentUnlockMode.method_15434());
        }
        if (this.customBlockReachRadius >= 0) {
            nbt.method_10569("custom_block_reach_radius", this.customBlockReachRadius);
        }
        super.method_11007(nbt, registryLookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (nbt.method_10573("CustomName", 8)) {
            this.customName = RPGEnchantingTableBlockEntity.method_59894((String)nbt.method_10558("CustomName"), (class_7225.class_7874)registryLookup);
        }
        if (nbt.method_10545("custom_book_cost")) {
            Optional<RPGEnchantingTableBlock.BookCost> optionalBookCost = RPGEnchantingTableBlock.BookCost.byName(nbt.method_10558("custom_book_cost"));
            optionalBookCost.ifPresent(bookCost -> {
                this.customBookCost = bookCost;
            });
        } else {
            this.customBookCost = null;
        }
        if (nbt.method_10545("custom_enchanting_mode")) {
            Optional<RPGEnchantingTableBlock.EnchantmentUnlockMode> optionalEnchantmentUnlockMode = RPGEnchantingTableBlock.EnchantmentUnlockMode.byName(nbt.method_10558("custom_enchanting_mode"));
            optionalEnchantmentUnlockMode.ifPresent(enchantmentUnlockMode -> {
                this.customEnchantmentUnlockMode = enchantmentUnlockMode;
            });
        } else {
            this.customEnchantmentUnlockMode = null;
        }
        this.customBlockReachRadius = nbt.method_10545("custom_block_reach_radius") ? nbt.method_10550("custom_block_reach_radius") : -1;
        super.method_11014(nbt, registryLookup);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, RPGEnchantingTableBlockEntity blockEntity) {
        float g;
        blockEntity.pageTurningSpeed = blockEntity.nextPageTurningSpeed;
        blockEntity.lastBookRotation = blockEntity.bookRotation;
        class_1657 playerEntity = world.method_18459((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 3.0, false);
        if (playerEntity != null) {
            double d = playerEntity.method_23317() - ((double)pos.method_10263() + 0.5);
            double e = playerEntity.method_23321() - ((double)pos.method_10260() + 0.5);
            blockEntity.targetBookRotation = (float)class_3532.method_15349((double)e, (double)d);
            blockEntity.nextPageTurningSpeed += 0.1f;
            if (blockEntity.nextPageTurningSpeed < 0.5f || RANDOM.method_43048(40) == 0) {
                float f = blockEntity.flipRandom;
                do {
                    blockEntity.flipRandom += (float)(RANDOM.method_43048(4) - RANDOM.method_43048(4));
                } while (f == blockEntity.flipRandom);
            }
        } else {
            blockEntity.targetBookRotation += 0.02f;
            blockEntity.nextPageTurningSpeed -= 0.1f;
        }
        while (blockEntity.bookRotation >= (float)Math.PI) {
            blockEntity.bookRotation -= (float)Math.PI * 2;
        }
        while (blockEntity.bookRotation < (float)(-Math.PI)) {
            blockEntity.bookRotation += (float)Math.PI * 2;
        }
        while (blockEntity.targetBookRotation >= (float)Math.PI) {
            blockEntity.targetBookRotation -= (float)Math.PI * 2;
        }
        while (blockEntity.targetBookRotation < (float)(-Math.PI)) {
            blockEntity.targetBookRotation += (float)Math.PI * 2;
        }
        for (g = blockEntity.targetBookRotation - blockEntity.bookRotation; g >= (float)Math.PI; g -= (float)Math.PI * 2) {
        }
        while (g < (float)(-Math.PI)) {
            g += (float)Math.PI * 2;
        }
        blockEntity.bookRotation += g * 0.4f;
        blockEntity.nextPageTurningSpeed = class_3532.method_15363((float)blockEntity.nextPageTurningSpeed, (float)0.0f, (float)1.0f);
        ++blockEntity.ticks;
        blockEntity.pageAngle = blockEntity.nextPageAngle;
        float h = (blockEntity.flipRandom - blockEntity.nextPageAngle) * 0.4f;
        float i = 0.2f;
        h = class_3532.method_15363((float)h, (float)-0.2f, (float)0.2f);
        blockEntity.flipTurn += (h - blockEntity.flipTurn) * 0.9f;
        blockEntity.nextPageAngle += blockEntity.flipTurn;
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : class_2561.method_43471((String)"gui.rpg_enchanting_table.title");
    }

    public void setCustomName(@Nullable class_2561 customName) {
        this.customName = customName;
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        this.customName = (class_2561)components.method_58694(class_9334.field_49631);
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(class_9334.field_49631, (Object)this.customName);
    }

    public void method_57569(class_2487 nbt) {
        nbt.method_10551("CustomName");
    }
}

