/*
 * Decompiled with CFR 0.152.
 */
package me.juusk.webhookintegration;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import me.juusk.webhookintegration.util.Config;
import me.juusk.webhookintegration.util.DiscordWebhook;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2556;
import net.minecraft.class_310;
import net.minecraft.class_418;
import net.minecraft.class_437;
import net.minecraft.class_7471;

@Environment(value=EnvType.CLIENT)
public class WebhookIntegrationClient
implements ClientModInitializer {
    public static DiscordWebhook webhook;
    public static WebhookIntegrationClient INSTANCE;

    public void onInitializeClient() {
        Config.HANDLER.load();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {});
    }

    public void onOpenScreen(class_437 screen) {
        assert (class_310.method_1551().field_1724 != null);
        if (webhook == null) {
            return;
        }
        if (screen instanceof class_418) {
            WebhookIntegrationClient.sendDeathMessage();
        }
    }

    public static void onChatMessage(class_7471 message, GameProfile sender, class_2556.class_7602 params) {
        assert (class_310.method_1551().field_1724 != null);
        if (webhook == null) {
            return;
        }
        String title = sender.getName();
        Object messageContent = "";
        if (!Config.chatEnabled) {
            return;
        }
        if (Config.chatEmbed) {
            DiscordWebhook.EmbedObject embedObject = new DiscordWebhook.EmbedObject();
            embedObject.setTitle(title);
            embedObject.addField("Message:", message.method_46291().getString(), false);
            webhook.addEmbed(embedObject);
        } else {
            messageContent = (String)messageContent + "\n #" + title;
            messageContent = (String)messageContent + "\n " + String.valueOf(message.method_46291());
        }
        webhook.setContent((String)messageContent);
        try {
            webhook.execute();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        webhook.clearEmbeds();
    }

    public static void setWebhookURL(String url) {
        Config.webhookUrl = url;
        WebhookIntegrationClient.onWebhookURLChanged();
    }

    public static String getWebhookURL() {
        return Config.webhookUrl;
    }

    private static void onWebhookURLChanged() {
        if (!Config.webhookUrl.isEmpty()) {
            webhook = new DiscordWebhook(Config.webhookUrl);
        }
    }

    public static void setEnabled(Boolean enabled) {
        Config.enabled = enabled;
        WebhookIntegrationClient.onEnabledChanged();
    }

    public static void setDeathEnabled(Boolean enabled) {
        Config.deathEnabled = enabled;
        WebhookIntegrationClient.onEnabledChanged();
    }

    public static void setDeathEmbed(Boolean enabled) {
        Config.deathEmbed = enabled;
        WebhookIntegrationClient.onEnabledChanged();
    }

    public static void setChatEnabled(Boolean enabled) {
        Config.chatEnabled = enabled;
        WebhookIntegrationClient.onEnabledChanged();
    }

    public static void setChatEmbed(Boolean enabled) {
        Config.chatEmbed = enabled;
        WebhookIntegrationClient.onEnabledChanged();
    }

    public static Boolean getEnabled() {
        return Config.enabled;
    }

    public static Boolean getDeathEnabled() {
        return Config.deathEnabled;
    }

    public static Boolean getDeathEmbed() {
        return Config.deathEmbed;
    }

    public static Boolean getChatEnabled() {
        return Config.chatEnabled;
    }

    public static Boolean getChatEmbed() {
        return Config.chatEmbed;
    }

    private static void onEnabledChanged() {
        Config.HANDLER.save();
    }

    public static void setEmbedColor(Color embedColor) {
        Config.embedColor = embedColor;
        WebhookIntegrationClient.onEmbedColorChanged();
    }

    public static Color getEmbedColor() {
        return Config.embedColor;
    }

    private static void onEmbedColorChanged() {
        Config.HANDLER.save();
    }

    public static void setMessageTitle(String messageTitle) {
        Config.messageTitle = messageTitle;
        WebhookIntegrationClient.onMessageTitleChanged();
    }

    public static String getMessageTitle() {
        return Config.messageTitle;
    }

    private static void onMessageTitleChanged() {
        Config.HANDLER.save();
    }

    public static void setUserID(String userId) {
        Config.userId = userId;
        WebhookIntegrationClient.onUserIDChanged();
    }

    public static String getUserID() {
        return Config.userId;
    }

    private static void onUserIDChanged() {
        Config.HANDLER.save();
    }

    public static void setMessageCoordinates(Boolean messageCoordinates) {
        Config.messageCoordinates = messageCoordinates;
        WebhookIntegrationClient.onMessageCoordinatesChanged();
    }

    public static Boolean getMessageCoordinates() {
        return Config.messageCoordinates;
    }

    private static void onMessageCoordinatesChanged() {
        Config.HANDLER.save();
    }

    public static void setMessageWorldName(Boolean messageWorldName) {
        Config.messageWorldName = messageWorldName;
        WebhookIntegrationClient.onMessageWorldNameChanged();
    }

    public static Boolean getMessageWorldName() {
        return Config.messageWorldName;
    }

    private static void onMessageWorldNameChanged() {
        Config.HANDLER.save();
    }

    public static void setMention(Boolean mention) {
        Config.mention = mention;
        WebhookIntegrationClient.onMentionChanged();
    }

    public static Boolean getMention() {
        return Config.mention;
    }

    private static void onMentionChanged() {
        Config.HANDLER.save();
    }

    public static void sendDeathMessage() {
        assert (class_310.method_1551().field_1724 != null);
        if (webhook == null) {
            return;
        }
        String title = Config.messageTitle;
        Object messageContent = "";
        if (!Config.deathEnabled) {
            return;
        }
        if (Config.mention) {
            messageContent = (String)messageContent + "<@" + Config.userId + ">";
        }
        if (title.contains("{name}")) {
            title = title.replace("{name}", class_310.method_1551().field_1724.method_5477().getString());
            System.out.println("Replaced {name} with playername");
        }
        if (Config.deathEmbed) {
            DiscordWebhook.EmbedObject embedObject = new DiscordWebhook.EmbedObject();
            embedObject.setTitle(title);
            embedObject.setColor(Config.embedColor);
            DecimalFormat df = new DecimalFormat("###.###");
            if (Config.messageCoordinates) {
                embedObject.addField("Coordinates:", "X: " + df.format(class_310.method_1551().field_1724.method_23317()) + " Y: " + df.format(class_310.method_1551().field_1724.method_23318()) + " Z: " + df.format(class_310.method_1551().field_1724.method_23321()), false);
            }
            if (Config.messageWorldName) {
                embedObject.addField("World:", class_310.method_1551().field_1687.method_27983().method_29177().method_12832(), false);
            }
            webhook.addEmbed(embedObject);
        } else {
            messageContent = (String)messageContent + "\n #" + title;
            DecimalFormat df = new DecimalFormat("###.###");
            if (Config.messageCoordinates) {
                messageContent = (String)messageContent + "\n *Coordinates*\n X: " + df.format(class_310.method_1551().field_1724.method_23317()) + "\n Y: " + df.format(class_310.method_1551().field_1724.method_23318()) + "\n Z: " + df.format(class_310.method_1551().field_1724.method_23321());
            }
            if (Config.messageWorldName) {
                messageContent = (String)messageContent + "\n *World* \n" + class_310.method_1551().field_1687.method_27983().method_29177().method_12832();
            }
        }
        webhook.setContent((String)messageContent);
        try {
            webhook.execute();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        webhook.clearEmbeds();
    }

    static {
        INSTANCE = new WebhookIntegrationClient();
    }
}

