/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.moderntemperature.networking.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.redfox.moderntemperature.temperature.PlayerTemperatureProvider;

public class SetTemperatureC2SPacket {
    private final float temperature;

    public SetTemperatureC2SPacket(float temperature) {
        this.temperature = temperature;
    }

    public SetTemperatureC2SPacket(FriendlyByteBuf buf) {
        this.temperature = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.temperature);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                player.getCapability(PlayerTemperatureProvider.PlAYER_TEMPERATURE).ifPresent(playerTemperature -> playerTemperature.setTemperature(this.temperature));
            }
        });
        return true;
    }
}

