/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.moderntemperature.temperature;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.redfox.moderntemperature.config.ModernTemperatureCommonConfigs;
import net.redfox.moderntemperature.util.MathHelper;
import oshi.util.tuples.Pair;

@AutoRegisterCapability
public class PlayerTemperature {
    private static final HashMap<String, Integer> BIOME_VALUES = new HashMap();
    private static final HashMap<String, Integer> INSULATOR_VALUES = new HashMap();
    private static final HashMap<String, Integer> FLUID_TEMPERATURE_VALUES = new HashMap();
    private static final HashMap<String, Integer> WALKING_ON_TOP_VALUES = new HashMap();
    private static final HashMap<String, Integer> WALKING_ON_TOP_MINI_BLOCKS_VALUES = new HashMap();
    private static final HashMap<String, Pair<Integer, Integer>> ARMOR_VALUES = new HashMap();
    private float temperature = 0.0f;

    public float getTemperature() {
        return MathHelper.roundToOneDecimal(this.temperature);
    }

    public void setTemperature(float temperature) {
        this.temperature = MathHelper.roundToOneDecimal(temperature);
    }

    public void copyFrom(PlayerTemperature other) {
        this.temperature = MathHelper.roundToOneDecimal(other.temperature);
    }

    public void approachTemperature(float goal) {
        float difference = MathHelper.roundToOneDecimal(Math.max(0.1, (double)Math.min(5.0f, Math.abs(goal - this.temperature) / 10.0f)) * 10.0 / 10.0);
        if (this.temperature > goal) {
            this.temperature -= difference;
        } else if (this.temperature < goal) {
            this.temperature += difference;
        }
    }

    public void saveNBTData(CompoundTag nbt) {
        nbt.m_128350_("temperature", MathHelper.roundToOneDecimal(this.temperature));
    }

    public void loadNBTData(CompoundTag nbt) {
        this.temperature = MathHelper.roundToOneDecimal(nbt.m_128457_("temperature"));
    }

    public static void populateConfigLists() {
        PlayerTemperature.populateListFromConfig(ModernTemperatureCommonConfigs.BIOME_TEMPERATURE, BIOME_VALUES);
        PlayerTemperature.populateListFromConfig(ModernTemperatureCommonConfigs.INSULATORS, INSULATOR_VALUES);
        PlayerTemperature.populateListFromConfig(ModernTemperatureCommonConfigs.FLUID_TEMPERATURES, FLUID_TEMPERATURE_VALUES);
        PlayerTemperature.populateListFromConfig(ModernTemperatureCommonConfigs.WALKING_ON_TOP_BOOTS, WALKING_ON_TOP_VALUES);
        PlayerTemperature.populateListFromConfig(ModernTemperatureCommonConfigs.WALKING_ON_TOP_MINI_BLOCKS_BOOTS, WALKING_ON_TOP_MINI_BLOCKS_VALUES);
        PlayerTemperature.populatePairMapFromConfig(ModernTemperatureCommonConfigs.ARMOR, ARMOR_VALUES);
    }

    private static void populateListFromConfig(ForgeConfigSpec.ConfigValue<List<String>> config, Map<String, Integer> map) {
        List configValues = (List)config.get();
        for (String value : configValues) {
            String[] split = value.split(",");
            map.put(split[0], Integer.parseInt(split[1]));
        }
    }

    private static void populatePairMapFromConfig(ForgeConfigSpec.ConfigValue<List<String>> config, Map<String, Pair<Integer, Integer>> map) {
        List configValues = (List)config.get();
        for (String value : configValues) {
            String[] split = value.split(",");
            map.put(split[0], (Pair<Integer, Integer>)new Pair((Object)Integer.parseInt(split[1]), (Object)Integer.parseInt(split[2])));
        }
    }

    private static <T> String getItemNameFromKey(Holder<T> holder) {
        return holder.m_203543_().map(key -> key.m_135782_().toString()).orElse("default");
    }

    public static float calculateTemperatureGoal(ServerPlayer player) {
        float goalTemperature = 0.0f;
        String currentBiome = PlayerTemperature.getItemNameFromKey(player.f_19853_.m_204166_(player.m_20183_()));
        if (BIOME_VALUES.containsKey(currentBiome)) {
            goalTemperature = BIOME_VALUES.get(currentBiome).intValue();
        }
        for (String insulator : INSULATOR_VALUES.keySet()) {
            if (player.f_19853_.m_45556_(player.m_20191_().m_82400_(5.0)).filter(blockState -> {
                String blockName = PlayerTemperature.getItemNameFromKey(blockState.m_222976_());
                return blockName.equals(insulator);
            }).toArray().length <= 0 || !INSULATOR_VALUES.containsKey(insulator)) continue;
            goalTemperature += (float)INSULATOR_VALUES.get(insulator).intValue();
        }
        String blockName = PlayerTemperature.getItemNameFromKey(player.f_19853_.m_8055_(player.m_20183_()).m_222976_());
        if (FLUID_TEMPERATURE_VALUES.containsKey(blockName)) {
            goalTemperature += (float)FLUID_TEMPERATURE_VALUES.get(blockName).intValue();
        }
        if (player.m_6844_(EquipmentSlot.FEET).m_41619_()) {
            String blockBelowName = PlayerTemperature.getItemNameFromKey(player.f_19853_.m_8055_(player.m_20183_().m_7495_()).m_222976_());
            if (WALKING_ON_TOP_VALUES.containsKey(blockBelowName)) {
                goalTemperature += (float)WALKING_ON_TOP_VALUES.get(blockBelowName).intValue();
            }
            if (WALKING_ON_TOP_MINI_BLOCKS_VALUES.containsKey(blockName)) {
                goalTemperature += (float)WALKING_ON_TOP_MINI_BLOCKS_VALUES.get(blockName).intValue();
            }
        }
        if (player.f_19853_.m_46758_(player.m_20183_())) {
            goalTemperature -= 30.0f;
        }
        if (player.f_19853_.m_46471_() && ((Biome)player.f_19853_.m_204166_(player.m_20183_()).m_203334_()).m_198904_(player.m_20183_()) && player.f_19853_.m_45527_(player.m_20183_())) {
            goalTemperature -= 60.0f;
        }
        goalTemperature = player.f_19853_.m_46461_() ? (goalTemperature += 10.0f) : (goalTemperature -= 10.0f);
        if (player.m_20094_() > 0) {
            goalTemperature += 50.0f;
        }
        if (player.m_20186_() < 40.0) {
            goalTemperature -= MathHelper.roundToOneDecimal(Math.abs((float)((player.m_20186_() - 40.0) / 5.0)));
        }
        if (player.m_20186_() > 80.0) {
            goalTemperature -= MathHelper.roundToOneDecimal(Math.abs((float)((80.0 - player.m_20186_()) / 5.0)));
        }
        Pair<Integer, Integer> resistances = PlayerTemperature.calculateHeatAndColdResistance(player);
        if (goalTemperature < 0.0f) {
            if ((goalTemperature += (float)((Integer)resistances.getB()).intValue()) > 0.0f) {
                goalTemperature = 0.0f;
            }
        } else if (goalTemperature > 0.0f && (goalTemperature -= (float)((Integer)resistances.getA()).intValue()) < 0.0f) {
            goalTemperature = 0.0f;
        }
        return goalTemperature + MathHelper.roundToOneDecimal(Math.random() - 0.5);
    }

    public static Pair<Integer, Integer> calculateHeatAndColdResistance(ServerPlayer player) {
        String itemName;
        int coldResistance = 0;
        int heatResistance = 0;
        if (!player.m_6844_(EquipmentSlot.HEAD).m_41619_() && ARMOR_VALUES.containsKey(itemName = PlayerTemperature.getItemNameFromKey(player.m_6844_(EquipmentSlot.HEAD).m_220173_()))) {
            heatResistance += ((Integer)ARMOR_VALUES.get(itemName).getA()).intValue();
            coldResistance += ((Integer)ARMOR_VALUES.get(itemName).getB()).intValue();
        }
        if (!player.m_6844_(EquipmentSlot.CHEST).m_41619_() && ARMOR_VALUES.containsKey(itemName = PlayerTemperature.getItemNameFromKey(player.m_6844_(EquipmentSlot.CHEST).m_220173_()))) {
            heatResistance += ((Integer)ARMOR_VALUES.get(itemName).getA()).intValue();
            coldResistance += ((Integer)ARMOR_VALUES.get(itemName).getB()).intValue();
        }
        if (!player.m_6844_(EquipmentSlot.LEGS).m_41619_() && ARMOR_VALUES.containsKey(itemName = PlayerTemperature.getItemNameFromKey(player.m_6844_(EquipmentSlot.LEGS).m_220173_()))) {
            heatResistance += ((Integer)ARMOR_VALUES.get(itemName).getA()).intValue();
            coldResistance += ((Integer)ARMOR_VALUES.get(itemName).getB()).intValue();
        }
        if (!player.m_6844_(EquipmentSlot.FEET).m_41619_() && ARMOR_VALUES.containsKey(itemName = PlayerTemperature.getItemNameFromKey(player.m_6844_(EquipmentSlot.FEET).m_220173_()))) {
            heatResistance += ((Integer)ARMOR_VALUES.get(itemName).getA()).intValue();
            coldResistance += ((Integer)ARMOR_VALUES.get(itemName).getB()).intValue();
        }
        return new Pair((Object)heatResistance, (Object)coldResistance);
    }
}

