/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.moderntemperature.client;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.redfox.moderntemperature.client.ClientTemperatureData;
import net.redfox.moderntemperature.config.ModernTemperatureClientConfigs;

public class TemperatureHudOverlay {
    public static boolean gaugeEnabled = true;
    public static boolean readingEnabled = true;
    private static final ResourceLocation TEMPERATURE_0 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/0.png");
    private static final ResourceLocation TEMPERATURE_1 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/1.png");
    private static final ResourceLocation TEMPERATURE_2 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/2.png");
    private static final ResourceLocation TEMPERATURE_3 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/3.png");
    private static final ResourceLocation TEMPERATURE_4 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/4.png");
    private static final ResourceLocation TEMPERATURE_5 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/5.png");
    private static final ResourceLocation TEMPERATURE_6 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/6.png");
    private static final ResourceLocation TEMPERATURE_7 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/7.png");
    private static final ResourceLocation TEMPERATURE_8 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/8.png");
    private static final ResourceLocation TEMPERATURE_9 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/9.png");
    private static final ResourceLocation TEMPERATURE_10 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/10.png");
    private static final ResourceLocation TEMPERATURE_11 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/11.png");
    private static final ResourceLocation TEMPERATURE_12 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/12.png");
    private static final ResourceLocation TEMPERATURE_13 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/13.png");
    private static final ResourceLocation TEMPERATURE_14 = ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"textures/gui/temperature_gauge/14.png");
    public static final IGuiOverlay TEMPERATURE_GAUGE = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        if (!gaugeEnabled) {
            return;
        }
        int OVERLAY_WIDTH = 16;
        int OVERLAY_HEIGHT = 16;
        int OVERLAY_X = screenWidth / 2 - 8;
        int OVERLAY_Y = screenHeight - 54;
        if (ClientTemperatureData.getPlayerTemperature() >= 80.0f || ClientTemperatureData.getPlayerTemperature() <= -80.0f) {
            switch ((int)(Math.random() * 4.0) + 1) {
                case 1: {
                    ++OVERLAY_X;
                }
                case 2: {
                    --OVERLAY_X;
                }
                case 3: {
                    ++OVERLAY_Y;
                }
                case 4: {
                    --OVERLAY_Y;
                }
            }
        }
        guiGraphics.m_280163_(TemperatureHudOverlay.getTemperatureImage(), OVERLAY_X, OVERLAY_Y, 0.0f, 0.0f, 16, 16, 16, 16);
    };
    public static final IGuiOverlay TEMPERATURE_READING = (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
        if (!gaugeEnabled) {
            return;
        }
        int OVERLAY_X = 2;
        int OVERLAY_Y = 2;
        poseStack.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)("Temp: " + ClientTemperatureData.getPlayerTemperature())), OVERLAY_X, OVERLAY_Y, ChatFormatting.WHITE.m_126665_().intValue());
    };

    public static void initialize() {
        String displayMode;
        switch (displayMode = (String)ModernTemperatureClientConfigs.DISPLAY_MODE.get()) {
            case "GAUGE": {
                readingEnabled = false;
                break;
            }
            case "NUMBER": {
                gaugeEnabled = false;
                break;
            }
            case "NONE": {
                gaugeEnabled = false;
                readingEnabled = false;
            }
        }
    }

    private static ResourceLocation getTemperatureImage() {
        float temperature = ClientTemperatureData.getPlayerTemperature();
        if (temperature > 200.0f) {
            return TEMPERATURE_14;
        }
        if (TemperatureHudOverlay.isBetween(temperature, 170, 200)) {
            return TEMPERATURE_13;
        }
        if (TemperatureHudOverlay.isBetween(temperature, 140, 170)) {
            return TEMPERATURE_12;
        }
        if (TemperatureHudOverlay.isBetween(temperature, 110, 140)) {
            return TEMPERATURE_11;
        }
        if (TemperatureHudOverlay.isBetween(temperature, 80, 110)) {
            return TEMPERATURE_10;
        }
        if (TemperatureHudOverlay.isBetween(temperature, 50, 80)) {
            return TEMPERATURE_9;
        }
        if (TemperatureHudOverlay.isBetween(temperature, 20, 50)) {
            return TEMPERATURE_8;
        }
        if (TemperatureHudOverlay.isBetween(temperature, -20, 20)) {
            return TEMPERATURE_7;
        }
        if (TemperatureHudOverlay.isBetween(temperature, -50, -20)) {
            return TEMPERATURE_6;
        }
        if (TemperatureHudOverlay.isBetween(temperature, -80, -50)) {
            return TEMPERATURE_5;
        }
        if (TemperatureHudOverlay.isBetween(temperature, -110, -80)) {
            return TEMPERATURE_4;
        }
        if (TemperatureHudOverlay.isBetween(temperature, -140, -110)) {
            return TEMPERATURE_3;
        }
        if (TemperatureHudOverlay.isBetween(temperature, -170, -140)) {
            return TEMPERATURE_2;
        }
        if (TemperatureHudOverlay.isBetween(temperature, -200, -170)) {
            return TEMPERATURE_1;
        }
        if (temperature < -200.0f) {
            return TEMPERATURE_0;
        }
        return TEMPERATURE_7;
    }

    private static boolean isBetween(float compare, int min, int max) {
        return compare > (float)min && compare <= (float)max;
    }
}

