/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.moderntemperature.event;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.command.ConfigCommand;
import net.redfox.moderntemperature.command.GetTemperature;
import net.redfox.moderntemperature.command.SetTemperature;
import net.redfox.moderntemperature.effect.ModEffects;
import net.redfox.moderntemperature.networking.ModPackets;
import net.redfox.moderntemperature.networking.packet.TemperatureDataSyncS2CPacket;
import net.redfox.moderntemperature.temperature.PlayerTemperature;
import net.redfox.moderntemperature.temperature.PlayerTemperatureProvider;

@Mod.EventBusSubscriber(modid="moderntemperature")
public class ModEvents {
    @SubscribeEvent
    public static void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.getServer().m_129921_() % 20 == 0) {
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                player.getCapability(PlayerTemperatureProvider.PLAYER_TEMPERATURE).ifPresent(playerTemperature -> {
                    float approachingTemperature = PlayerTemperature.calculateTemperatureGoal(player);
                    float temp = playerTemperature.getTemperature();
                    if (temp >= 80.0f) {
                        player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.HEAT_STROKE.get(), 120, Math.abs((int)((50.0f - temp) / 30.0f)) - 1, false, false, true));
                    } else if (temp <= -80.0f) {
                        player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.HYPOTHERMIA.get(), 120, Math.abs((int)((temp + 50.0f) / 30.0f)) - 1, false, false, true));
                    }
                    playerTemperature.approachTemperature(approachingTemperature);
                    ModPackets.sendToClient(new TemperatureDataSyncS2CPacket(playerTemperature.getTemperature()), player);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayerEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerTemperatureProvider.PLAYER_TEMPERATURE).isPresent()) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"moderntemperature", (String)"properties"), (ICapabilityProvider)new PlayerTemperatureProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClonedEvent(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getEntity().getCapability(PlayerTemperatureProvider.PLAYER_TEMPERATURE).ifPresent(playerTemperature -> playerTemperature.setTemperature(60.0f));
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorldEvent(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.getCapability(PlayerTemperatureProvider.PLAYER_TEMPERATURE).ifPresent(playerTemperature -> ModPackets.sendToClient(new TemperatureDataSyncS2CPacket(playerTemperature.getTemperature()), player));
        }
    }

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        new GetTemperature((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new SetTemperature((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }
}

