/*
 * Decompiled with CFR 0.152.
 */
package com.kasetoatz.biggerhotbar.state;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_642;

public class StateManager {
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("bh_entries.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ArrayList<String> DATA = new ArrayList();

    public static void load() {
        if (Files.exists(FILE, new LinkOption[0])) {
            try {
                String json = Files.readString(FILE);
                Type type = new TypeToken<ArrayList<String>>(){}.getType();
                DATA = (ArrayList)GSON.fromJson(json, type);
            }
            catch (IOException exc) {
                throw new class_148(class_128.method_560((Throwable)exc, (String)"Loading config file."));
            }
        }
    }

    private static void save() {
        try {
            Files.writeString(FILE, (CharSequence)GSON.toJson(DATA), new OpenOption[0]);
        }
        catch (IOException exc) {
            throw new class_148(class_128.method_560((Throwable)exc, (String)"Savinng config file."));
        }
    }

    private static String getKey() {
        class_310 client = class_310.method_1551();
        class_642 info = client.method_1558();
        if (info != null) {
            return info.field_3761;
        }
        if (client.method_1542() && client.method_1576() != null) {
            return client.method_1576().method_27050(class_5218.field_24188).getParent().getFileName().toString();
        }
        return null;
    }

    public static boolean isFlipped() {
        String key = StateManager.getKey();
        if (key != null) {
            return DATA.contains(key);
        }
        return false;
    }

    public static void toggleFlipped() {
        String key = StateManager.getKey();
        if (key != null) {
            if (DATA.contains(key)) {
                DATA.remove(key);
            } else {
                DATA.add(key);
            }
            StateManager.save();
        }
    }
}

