/*
 * Decompiled with CFR 0.152.
 */
package com.simpfey.kih.init;

import com.simpfey.kih.KihMod;
import com.simpfey.kih.init.KihModScreens;
import com.simpfey.kih.network.MenuStateUpdateMessage;
import com.simpfey.kih.world.inventory.HealthMenu;
import com.simpfey.kih.world.inventory.ReviveGuiMenu;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class KihModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"kih");
    public static final RegistryObject<MenuType<ReviveGuiMenu>> REVIVE_GUI = REGISTRY.register("revive_gui", () -> IForgeMenuType.create(ReviveGuiMenu::new));
    public static final RegistryObject<MenuType<HealthMenu>> HEALTH = REGISTRY.register("health", () -> IForgeMenuType.create(HealthMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                KihMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.m_9236_().f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof KihModScreens.ScreenAccessor) {
                    KihModScreens.ScreenAccessor accessor = (KihModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                KihMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

