/*
 * Decompiled with CFR 0.152.
 */
package com.simpfey.kih.network;

import com.simpfey.kih.KihMod;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class KihModVariables {
    public static double Ticks = 0.0;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        KihMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        KihMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.disinfected = message.data.disinfected;
                    variables.bleeding = message.data.bleeding;
                    variables.BandageLifeSpan = message.data.BandageLifeSpan;
                    variables.LastX = message.data.LastX;
                    variables.LastZ = message.data.LastZ;
                    variables.coughDelay = message.data.coughDelay;
                    variables.LegsBroken = message.data.LegsBroken;
                    variables.PlayerTemp = message.data.PlayerTemp;
                    variables.timeUnderWater = message.data.timeUnderWater;
                    variables.BiomeTempArndPlayer = message.data.BiomeTempArndPlayer;
                    variables.AdditionalTemp = message.data.AdditionalTemp;
                    variables.PlayerStamina = message.data.PlayerStamina;
                    variables.GetShownFor = message.data.GetShownFor;
                    variables.sanity = message.data.sanity;
                    variables.fatigue = message.data.fatigue;
                    variables.CloseToDeath = message.data.CloseToDeath;
                    variables.RevivingWho = message.data.RevivingWho;
                    variables.ReviveButtonClicked = message.data.ReviveButtonClicked;
                    variables.MedicalLevel = message.data.MedicalLevel;
                    variables.antibiotics = message.data.antibiotics;
                    variables.AntiBioticsLifeSpan = message.data.AntiBioticsLifeSpan;
                    variables.PainKiller = message.data.PainKiller;
                    variables.PainKillerT = message.data.PainKillerT;
                    variables.sanitytimer = message.data.sanitytimer;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean disinfected = false;
        public boolean bleeding = true;
        public double BandageLifeSpan = 0.0;
        public double LastX = 0.0;
        public double LastZ = 0.0;
        public double coughDelay = 0.0;
        public double LegsBroken = 6.0;
        public double PlayerTemp = 0.0;
        public double timeUnderWater = 0.0;
        public double BiomeTempArndPlayer = 210.0;
        public double AdditionalTemp = 0.0;
        public double PlayerStamina = 3000.0;
        public double GetShownFor = 0.0;
        public double sanity = 100.0;
        public double fatigue = 0.0;
        public boolean CloseToDeath = false;
        public String RevivingWho = "\"\"";
        public double ReviveButtonClicked = 0.0;
        public double MedicalLevel = 0.0;
        public boolean antibiotics = false;
        public double AntiBioticsLifeSpan = 0.0;
        public boolean PainKiller = false;
        public double PainKillerT = 0.0;
        public double sanitytimer = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                KihMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("disinfected", this.disinfected);
            nbt.m_128379_("bleeding", this.bleeding);
            nbt.m_128347_("BandageLifeSpan", this.BandageLifeSpan);
            nbt.m_128347_("LastX", this.LastX);
            nbt.m_128347_("LastZ", this.LastZ);
            nbt.m_128347_("coughDelay", this.coughDelay);
            nbt.m_128347_("LegsBroken", this.LegsBroken);
            nbt.m_128347_("PlayerTemp", this.PlayerTemp);
            nbt.m_128347_("timeUnderWater", this.timeUnderWater);
            nbt.m_128347_("BiomeTempArndPlayer", this.BiomeTempArndPlayer);
            nbt.m_128347_("AdditionalTemp", this.AdditionalTemp);
            nbt.m_128347_("PlayerStamina", this.PlayerStamina);
            nbt.m_128347_("GetShownFor", this.GetShownFor);
            nbt.m_128347_("sanity", this.sanity);
            nbt.m_128347_("fatigue", this.fatigue);
            nbt.m_128379_("CloseToDeath", this.CloseToDeath);
            nbt.m_128359_("RevivingWho", this.RevivingWho);
            nbt.m_128347_("ReviveButtonClicked", this.ReviveButtonClicked);
            nbt.m_128347_("MedicalLevel", this.MedicalLevel);
            nbt.m_128379_("antibiotics", this.antibiotics);
            nbt.m_128347_("AntiBioticsLifeSpan", this.AntiBioticsLifeSpan);
            nbt.m_128379_("PainKiller", this.PainKiller);
            nbt.m_128347_("PainKillerT", this.PainKillerT);
            nbt.m_128347_("sanitytimer", this.sanitytimer);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.disinfected = nbt.m_128471_("disinfected");
            this.bleeding = nbt.m_128471_("bleeding");
            this.BandageLifeSpan = nbt.m_128459_("BandageLifeSpan");
            this.LastX = nbt.m_128459_("LastX");
            this.LastZ = nbt.m_128459_("LastZ");
            this.coughDelay = nbt.m_128459_("coughDelay");
            this.LegsBroken = nbt.m_128459_("LegsBroken");
            this.PlayerTemp = nbt.m_128459_("PlayerTemp");
            this.timeUnderWater = nbt.m_128459_("timeUnderWater");
            this.BiomeTempArndPlayer = nbt.m_128459_("BiomeTempArndPlayer");
            this.AdditionalTemp = nbt.m_128459_("AdditionalTemp");
            this.PlayerStamina = nbt.m_128459_("PlayerStamina");
            this.GetShownFor = nbt.m_128459_("GetShownFor");
            this.sanity = nbt.m_128459_("sanity");
            this.fatigue = nbt.m_128459_("fatigue");
            this.CloseToDeath = nbt.m_128471_("CloseToDeath");
            this.RevivingWho = nbt.m_128461_("RevivingWho");
            this.ReviveButtonClicked = nbt.m_128459_("ReviveButtonClicked");
            this.MedicalLevel = nbt.m_128459_("MedicalLevel");
            this.antibiotics = nbt.m_128471_("antibiotics");
            this.AntiBioticsLifeSpan = nbt.m_128459_("AntiBioticsLifeSpan");
            this.PainKiller = nbt.m_128471_("PainKiller");
            this.PainKillerT = nbt.m_128459_("PainKillerT");
            this.sanitytimer = nbt.m_128459_("sanitytimer");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"kih", (String)"player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "kih_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                KihMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "kih_worldvars";
        public boolean temperatureS = true;
        public boolean reviveS = true;
        public boolean fatigueS = true;
        public boolean CompatibilityLayer = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.temperatureS = nbt.m_128471_("temperatureS");
            this.reviveS = nbt.m_128471_("reviveS");
            this.fatigueS = nbt.m_128471_("fatigueS");
            this.CompatibilityLayer = nbt.m_128471_("CompatibilityLayer");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("temperatureS", this.temperatureS);
            nbt.m_128379_("reviveS", this.reviveS);
            nbt.m_128379_("fatigueS", this.fatigueS);
            nbt.m_128379_("CompatibilityLayer", this.CompatibilityLayer);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                KihMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.GetShownFor = original.GetShownFor;
            clone.MedicalLevel = original.MedicalLevel;
            if (!event.isWasDeath()) {
                clone.disinfected = original.disinfected;
                clone.bleeding = original.bleeding;
                clone.BandageLifeSpan = original.BandageLifeSpan;
                clone.LastX = original.LastX;
                clone.LastZ = original.LastZ;
                clone.coughDelay = original.coughDelay;
                clone.LegsBroken = original.LegsBroken;
                clone.PlayerTemp = original.PlayerTemp;
                clone.timeUnderWater = original.timeUnderWater;
                clone.BiomeTempArndPlayer = original.BiomeTempArndPlayer;
                clone.AdditionalTemp = original.AdditionalTemp;
                clone.PlayerStamina = original.PlayerStamina;
                clone.sanity = original.sanity;
                clone.fatigue = original.fatigue;
                clone.CloseToDeath = original.CloseToDeath;
                clone.RevivingWho = original.RevivingWho;
                clone.ReviveButtonClicked = original.ReviveButtonClicked;
                clone.antibiotics = original.antibiotics;
                clone.AntiBioticsLifeSpan = original.AntiBioticsLifeSpan;
                clone.PainKiller = original.PainKiller;
                clone.PainKillerT = original.PainKillerT;
                clone.sanitytimer = original.sanitytimer;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    KihMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    KihMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                KihMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

