/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.hfo_mod;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.ModInitializer;
import org.ivangeevo.hfo_mod.config.HFOModSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HFOMod
implements ModInitializer {
    public static final String MOD_ID = "hardcore_fluid_overhaul";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"hardcore_fluid_overhaul");
    public HFOModSettings settings;
    private static final String CONFIG_FILE_PATH = "./config/btwr/hardcoreFluidOverhaulCommon.json";
    private static HFOMod instance;

    public static HFOMod getInstance() {
        return instance;
    }

    public void onInitialize() {
        LOGGER.info("Initializing Hardcore Fluid Overhaul.");
        this.loadSettings();
        instance = this;
    }

    public void loadSettings() {
        File file = new File(CONFIG_FILE_PATH);
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (HFOModSettings)gson.fromJson((Reader)fileReader, HFOModSettings.class);
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not load Hardcore Fluid Overhaul settings: " + e.getLocalizedMessage());
            }
        } else {
            this.settings = new HFOModSettings();
        }
    }

    public void saveSettings() {
        Gson gson = new Gson();
        File file = new File(CONFIG_FILE_PATH);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not save Hardcore Fluid Overhaul settings: " + e.getLocalizedMessage());
        }
    }
}

