/*
 * Decompiled with CFR 0.152.
 */
package fuzs.respawninganimals.handler;

import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import fuzs.respawninganimals.RespawningAnimals;
import fuzs.respawninganimals.init.ModRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.jetbrains.annotations.Nullable;

public class AnimalSpawningHandler {
    private static final Set<EntitySpawnReason> PERSISTENT_SPAWN_TYPES = Set.of(EntitySpawnReason.STRUCTURE, EntitySpawnReason.BREEDING, EntitySpawnReason.TRIGGERED, EntitySpawnReason.BUCKET);

    public static void onServerStarted(MinecraftServer minecraftServer) {
        AnimalSpawningHandler.setCreatureAttributes(minecraftServer.getGameRules());
    }

    public static void setCreatureAttributes(GameRules gameRules) {
        boolean persistentAnimals;
        MobCategory.CREATURE.isPersistent = persistentAnimals = gameRules.getBoolean(ModRegistry.PERSISTENT_ANIMALS_GAME_RULE);
        MobCategory.CREATURE.max = persistentAnimals ? 10 : gameRules.getInt(ModRegistry.ANIMAL_MOB_CAP_GAME_RULE);
    }

    public static EventResult onCheckMobDespawn(Mob mob, ServerLevel serverLevel) {
        if (AnimalSpawningHandler.isAllowedToDespawn(mob, serverLevel.getGameRules())) {
            if (!mob.isPersistenceRequired() && !mob.requiresCustomPersistence()) {
                Player player = serverLevel.getNearestPlayer((Entity)mob, -1.0);
                if (player != null) {
                    MobCategory mobCategory;
                    int despawnDistance;
                    int despawnDistanceSqr;
                    double distanceToSqr = player.distanceToSqr((Entity)mob);
                    if (distanceToSqr > (double)(despawnDistanceSqr = (despawnDistance = (mobCategory = mob.getType().getCategory()).getDespawnDistance()) * despawnDistance)) {
                        return EventResult.ALLOW;
                    }
                    int noDespawnDistance = mobCategory.getNoDespawnDistance();
                    int noDespawnDistanceSqr = noDespawnDistance * noDespawnDistance;
                    if (mob.getNoActionTime() > 600 && mob.getRandom().nextInt(800) == 0 && distanceToSqr > (double)noDespawnDistanceSqr) {
                        return EventResult.ALLOW;
                    }
                    if (distanceToSqr < (double)noDespawnDistanceSqr) {
                        mob.setNoActionTime(0);
                    }
                    return EventResult.DENY;
                }
            } else {
                mob.setNoActionTime(0);
            }
        }
        return EventResult.PASS;
    }

    public static boolean isAllowedToDespawn(Mob mob, @Nullable GameRules gameRules) {
        if (AnimalSpawningHandler.isAnimalDespawningAllowed(mob.getType(), gameRules, mob.getType().getCategory())) {
            EntitySpawnReason entitySpawnReason = EntityHelper.getMobSpawnReason((Entity)mob);
            return entitySpawnReason != null && !PERSISTENT_SPAWN_TYPES.contains(entitySpawnReason);
        }
        return false;
    }

    public static boolean isAnimalDespawningAllowed(EntityType<?> entityType, @Nullable GameRules gameRules, MobCategory mobCategory) {
        if (gameRules != null && gameRules.getBoolean(ModRegistry.PERSISTENT_ANIMALS_GAME_RULE)) {
            return false;
        }
        if (entityType.is(ModRegistry.PERSISTENT_ANIMALS_ENTITY_TYPE_TAG)) {
            return false;
        }
        return mobCategory == MobCategory.CREATURE;
    }

    public static EventResult onEntityLoad(Entity entity, ServerLevel serverLevel, boolean isNewlySpawned) {
        EntitySpawnReason entitySpawnReason;
        if (isNewlySpawned && (entitySpawnReason = EntityHelper.getMobSpawnReason((Entity)entity)) == EntitySpawnReason.CHUNK_GENERATION) {
            AnimalSpawningHandler.applyCorrectMobCategory(entity.getType());
            if (AnimalSpawningHandler.isAnimalDespawningAllowed(entity.getType(), serverLevel.getGameRules(), MobCategory.CREATURE)) {
                return EventResult.INTERRUPT;
            }
        }
        AnimalSpawningHandler.setPersistenceForPersistentAnimal(entity);
        return EventResult.PASS;
    }

    private static void setPersistenceForPersistentAnimal(Entity entity) {
        Mob mob;
        if (entity instanceof Mob && (mob = (Mob)entity).getType().getCategory() == MobCategory.CREATURE && !mob.isPersistenceRequired() && !AnimalSpawningHandler.isAllowedToDespawn(mob, null)) {
            mob.setPersistenceRequired();
        }
    }

    private static void applyCorrectMobCategory(EntityType<?> entityType) {
        if (entityType.getCategory() != MobCategory.CREATURE) {
            ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
            Optional<String> issues = ModLoaderEnvironment.INSTANCE.getModContainer(resourceLocation.getNamespace()).map(modContainer -> (String)modContainer.getContactTypes().get("issues"));
            String modName = ModLoaderEnvironment.INSTANCE.getModContainer(resourceLocation.getNamespace()).map(ModContainer::getDisplayName).orElse(resourceLocation.getNamespace());
            RespawningAnimals.LOGGER.warn("Mismatched spawn type for {}! Mob is registered as {}, but spawning as {}. Report this to the author of {}" + issues.map(s -> " at " + s).orElse("") + ".", new Object[]{resourceLocation, entityType.getCategory(), MobCategory.CREATURE, modName});
            entityType.category = MobCategory.CREATURE;
        }
    }

    public static void onGatherPotentialSpawns(ServerLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, MobCategory mobCategory, BlockPos blockPos, List<Weighted<MobSpawnSettings.SpawnerData>> mobs) {
        if (mobCategory == MobCategory.CREATURE) {
            Iterator<Weighted<MobSpawnSettings.SpawnerData>> iterator = mobs.iterator();
            while (iterator.hasNext()) {
                Weighted<MobSpawnSettings.SpawnerData> spawnerData = iterator.next();
                AnimalSpawningHandler.applyCorrectMobCategory(((MobSpawnSettings.SpawnerData)spawnerData.value()).type());
                if (AnimalSpawningHandler.isAnimalDespawningAllowed(((MobSpawnSettings.SpawnerData)spawnerData.value()).type(), level.getGameRules(), MobCategory.CREATURE)) continue;
                iterator.remove();
            }
        }
    }
}

