package mod.crontent;

import mod.crontent.music.debug.MyDebugHudEntry;
import mod.crontent.music.definition.MusicDefinition;
import mod.crontent.music.definition.entries.MusicEntryType;
import mod.crontent.music.definition.entries.MusicEntryTypes;
import mod.crontent.music.definition.entries.MusicSituationalType;
import mod.crontent.music.management.loading.BiomeTagMapper;
import mod.crontent.music.management.loading.MusicDataLoader;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.minecraft.class_11631;
import net.minecraft.class_2378;
import net.minecraft.class_3264;
import net.minecraft.class_5321;
import net.minecraft.registry.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class VolumeGammaClient implements ClientModInitializer {
    public static final String MOD_ID = "volume_gamma";
    public static final String MOD_NAME = "Volume Gamma";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);


    public static final class_5321<class_2378<MusicDefinition>> MUSIC_DEFINITION_KEY = class_5321.method_29180(Utils.id("music_definition"));
    public static final class_5321<class_2378<MusicEntryType>> MUSIC_ENTRY_TYPE_KEY = class_5321.method_29180(Utils.id("music_entry_type"));


    @Override
    public void onInitializeClient() {
        MusicEntryType.initialize();
        MusicEntryTypes.initialize();
        MusicSituationalType.initialize();

        //DynamicRegistries.registerSynced(MUSIC_DEFINITION_KEY, MusicDefinition.CODEC)

        ResourceLoader.get(class_3264.field_14188).registerReloader(MusicDataLoader.ID, MusicDataLoader.INSTANCE);

        class_11631.method_72763(Utils.id("gamma_music"), new MyDebugHudEntry());

        CommonLifecycleEvents.TAGS_LOADED.register(BiomeTagMapper::generateMap);
    }
}