package mod.crontent.datagen.providers;

import mod.crontent.registries.GammaSounds;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_9793;
import java.util.concurrent.CompletableFuture;

public class GammaJukeboxSongProvider extends FabricDynamicRegistryProvider {
    public GammaJukeboxSongProvider(FabricDataOutput output, CompletableFuture<class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    public String method_10321() {
        return "Jukebox Songs";
    }

    @Override
    protected void configure(class_7874 registries, Entries entries) {
        register(entries, GammaSounds.WUOP, GammaSounds.MUSIC_WUOP, 194, 1);
        register(entries, GammaSounds.FLY, GammaSounds.MUSIC_FLY, 173, 1);
        register(entries, GammaSounds.HARVEST, GammaSounds.MUSIC_HARVEST, 165, 1);
        register(entries, GammaSounds.MELANC, GammaSounds.MUSIC_MELANC, 229, 1);
        register(entries, GammaSounds.LOOFAH, GammaSounds.MUSIC_LOOFAH, 81, 1);
        register(entries, GammaSounds.KENA, GammaSounds.MUSIC_KENA, 142, 1);
        register(entries, GammaSounds.BLUUPY, GammaSounds.MUSIC_BLUUPY, 196, 1);
    }

    private void register(
            Entries entries,
            class_5321<class_9793> key,
            class_6880.class_6883<class_3414> soundEvent, int lengthInSeconds, int comparatorOutput) {
        entries.add(key, new class_9793(soundEvent, class_2561.method_43471(class_156.method_646("jukebox_song", key.method_29177())), lengthInSeconds, comparatorOutput));
    }

}
