package mod.crontent.mixin.client;

import mod.crontent.Utils;
import mod.crontent.interfaces.ChunkBiomeCounterAccess;
import mod.crontent.interfaces.MusicStuffAccess;
import mod.crontent.music.management.loading.BiomeTagMapper;
import mod.crontent.music.management.GammaMusicManager;
import mod.crontent.music.management.MusicManagerEnums.Daytime;
import mod.crontent.music.management.MusicManagerEnums.SituationalType;
import mod.crontent.music.management.loading.MusicDataLoader;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_10383;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_5195;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8144;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

import java.util.ArrayList;
import java.util.HashSet;

import static mod.crontent.music.management.MusicManagerEnums.Daytime;
import static mod.crontent.music.management.MusicManagerEnums.SituationalType;


@Mixin(class_310.class)
public abstract class MinecraftClientMixin implements MusicStuffAccess {
    @Shadow
    @Nullable
    public class_638 world;

    @Unique
    class_10383 currentMusicInstance = new class_10383(
            new class_5195(class_7923.field_41172.method_47983(class_3417.field_42593), 10, 10, false));


    //TODO: remove or refactor for f3 screen
    @Override
    public HashSet<SituationalType> volume_gamma$getCurrentSituations() {
        return GammaMusicManager.INSTANCE.getSituations();
    }
    @Override
    public Daytime volume_gamma$getCurrentDaytime() {
        return GammaMusicManager.INSTANCE.getDaytime();
    }
    @Override
    public class_6880<class_1959> volume_gamma$getCurrentExactBiome() {
        return GammaMusicManager.INSTANCE.getExactBiome();
    }
    @Override
    public HashSet<class_6862<class_1959>> volume_gamma$getCurrentSurroundingBiomeTagsIntersection() {
        return GammaMusicManager.INSTANCE.getBiomeTagIntersection();
    }
    @Override
    public HashSet<class_6880<class_1959>> volume_gamma$getCurrentSurroundingBiomes() {
        return GammaMusicManager.INSTANCE.getBiomesSurrounding();
    }

    @Override
    public GammaMusicManager volume_gamma$getMusicManager() {
        return GammaMusicManager.INSTANCE;
    }

    @Override
    public class_10383 volume_gamma$getCurrentMusicInstance() {
        return currentMusicInstance;
    }


    /**
     * @author ahhaha
     * @reason fuck you
     */
    @Overwrite
    public class_10383 getMusicInstance() {

        //this can only be a value when credits are rolling
        class_5195 musicSound = (class_5195) class_8144.method_49077(((class_310) (Object) this).field_1755, class_437::method_50024);
        if (musicSound != null) {
            return new class_10383(musicSound);
        } else {
            fillPlayConditions();

            //TODO:
//            if (GammaMusicManager.INSTANCE.collectUsableEntries()) {
//                GammaMusicManager.INSTANCE.getUsableEntries().forEach(GammaMusicManager.INSTANCE::putMusicEntry);
//                //Only return new music instance when situation actually Changed
//            }
            GammaMusicManager.INSTANCE.collectUsableEntries();
            GammaMusicManager.INSTANCE.getUsableEntries().forEach(GammaMusicManager.INSTANCE::putMusicEntry);
            currentMusicInstance = GammaMusicManager.INSTANCE.getRandomMusicInstance();
            return currentMusicInstance;
        }

//        float f = 1;
//        return new MusicInstance(MusicType.UNDERWATER, f);
    }

    @Unique
    private void fillPlayConditions() {
        //TODO: Should probably do this on a lower frequency or even only on demand
        GammaMusicManager.INSTANCE.reset();

        if (((class_310) (Object) this).field_1724 != null) {
            class_746 player = ((class_310) (Object) this).field_1724;
            class_1937 world = player.method_73183();

            //TODO: Caveat: Modded dimension which might have time cycles are left out of daylight condition usage
            if ((world.method_27983() == class_1937.field_25179)) {
                GammaMusicManager.INSTANCE.setDaytime(world.method_8532());
            } else GammaMusicManager.INSTANCE.setDaytime(-1);

            GammaMusicManager.INSTANCE.deductSituations(world, player);
            GammaMusicManager.INSTANCE.setExactBiome(world.method_23753(player.method_24515()));


            /* Get Surrounding Biomes */

            class_1923 currentChunkPos = world.method_22350(player.method_24515()).method_12004();
            //TODO: midpoint circle algo
            int radius = 2;

            //TODO: only take into account a percentage
            for (int x = currentChunkPos.field_9181 - radius; x <= currentChunkPos.field_9181 + radius; x++) {
                for (int z = currentChunkPos.field_9180 - radius; z <= currentChunkPos.field_9180 + radius; z++) {
                    HashSet<class_6880<class_1959>> present = ((ChunkBiomeCounterAccess) world.method_8497(x, z)).gamma$getBiomesPresent();
                    present.removeIf(biomeRegistryEntry -> biomeRegistryEntry.method_40220(ConventionalBiomeTags.IS_CAVE));
                    GammaMusicManager.INSTANCE.addBiomesSurrounding(present);
                }
            }

            ArrayList<HashSet<class_6862<class_1959>>> surroundingBiomeTags = new ArrayList<>();

            GammaMusicManager.INSTANCE.getBiomesSurrounding().forEach(biomeRegistryEntry -> {
                HashSet<class_6862<class_1959>> tags = BiomeTagMapper.lookup(biomeRegistryEntry);
                surroundingBiomeTags.add(tags);
                //TODO: really general tags like is_overworld (used for game sounds) should only be used IF they are the single available tag, to not skew selection
                //This is achieved below in a really hacky way, assuming game music is stored in c:is_overworld
            });

            HashSet<class_6862<class_1959>> biomeTagIntersection = Utils.findIntersection(new HashSet<>(), surroundingBiomeTags.toArray(new HashSet[0]));
            for (class_6862<class_1959> biomeTagKey : biomeTagIntersection) {
                class_6862<class_1959> overworldTag = class_6862.method_40092(class_7924.field_41236, class_2960.method_60655("c", "is_overworld"));
                if(!biomeTagKey.equals(overworldTag) && MusicDataLoader.INSTANCE.definedTagKeys.contains(biomeTagKey)){
                    biomeTagIntersection.remove(overworldTag);
                    break;
                }
            }
            GammaMusicManager.INSTANCE.setBiomeTagIntersection(biomeTagIntersection);

        } else {
            GammaMusicManager.INSTANCE.addSituation(SituationalType.MENU);
        }
    }


}
