package mod.crontent.music.definition.entries;

import com.mojang.serialization.Codec;
import mod.crontent.VolumeGammaClient;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5195;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;
import java.util.Optional;

public abstract class MusicEntry<T> {
    //TODO: rough hack to make our music more likely (not sure if even works)
    public static final int DEFAULT_WEIGHT = 3;
    //TODO: This is actually never taken into account anywhere
    protected int weight;
    protected final String name;
    
    public static final Codec<MusicEntry> CODEC = MusicEntryType.REGISTRY.method_39673()
            .dispatch(MusicEntry::getType, MusicEntryType::codec);

    public MusicEntry(String name) {
        this.weight = DEFAULT_WEIGHT;
        this.name = name;
    }

    public MusicEntry(int weight, String name) {
        this.weight = weight;
        this.name = name;
    }

    public abstract MusicEntryType<?> getType();

    public abstract boolean matchesGivenCondition(T condition);

    public class_2960 getId() {
        return class_2960.method_60654(name);
    }

    @Override
    public boolean equals(Object obj) {
        return (obj instanceof MusicEntry otherEntry
                && otherEntry.name.equals(this.name)
                && otherEntry.weight == this.weight
                && otherEntry.getType().equals(this.getType()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, weight, getType());
    }

    public String getName() {
        return name;
    }

    public int getWeight() {
        return weight;
    }


    public class_5195 getMusicType(class_2960 id) {
        class_2960 prefixedId = class_2960.method_60655(id.method_12836(), "music.".concat(id.method_12832()));
        class_6880<class_3414> soundEvent = getSoundEventRegistryEntry(prefixedId);
        //TODO: polymorphism
        class_5195 ms = new class_5195(soundEvent, 12000, 24000, false);
        if (this instanceof SituationalMusicEntry e) {
            switch (e.getSituation()) {
                case MENU -> ms = new class_5195(soundEvent, 20, 600, true);
                //This seems unused as credits music is provided outside our mod
                case CREDITS -> new class_5195(soundEvent, 0, 0, true);
                case DRAGON -> new class_5195(soundEvent, 0, 0, true);
                case END -> new class_5195(soundEvent, 6000, 24000, true);
            }
        }
        return ms;
        //return new MusicSound(soundEvent, 12000, 24000, false);
    }

    public static @NotNull class_6880<class_3414> getSoundEventRegistryEntry(class_2960 id) {
        //TODO: proper handling of invalid sound
        Optional<class_6880.class_6883<class_3414>> entry = class_7923.field_41172.method_10223(id);
        if(entry.isEmpty()) VolumeGammaClient.LOGGER.warn("Sound Entry of ID {} is nonexistant.", id);
        return entry.isPresent()? entry.get() : class_7923.field_41172.method_47983(class_3417.field_42593);
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }
}
