package mod.crontent.music.management;

import mod.crontent.music.management.MusicManagerEnums.Daytime;
import mod.crontent.music.management.MusicManagerEnums.SituationalType;
import mod.crontent.music.management.loading.MusicDataLoader;
import mod.crontent.music.definition.entries.*;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_10383;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import static mod.crontent.music.management.MusicManagerEnums.*;

public class GammaMusicManager {
    public static final GammaMusicManager INSTANCE = new GammaMusicManager();
    private final class_5819 randomInstance = class_5819.method_43047();
    HashSet<SituationalType> situations;
    Daytime daytime;
    class_6880<class_1959> exactBiome;
    HashSet<class_6862<class_1959>> biomeTagIntersection = new HashSet<>();
    HashSet<class_6880<class_1959>> biomesSurrounding = new HashSet<>();


    private Map<MusicEntry, Set<class_2960>> usableEntries = new HashMap<>();


    //TODO: only apply for height dependent biomes
    Predicate<class_6880<class_1959>> shouldBiomeIncludedInTags = biome -> !biome.method_40220(ConventionalBiomeTags.IS_CAVE);

    public HashMap<class_5195, Integer> songPool;


    public GammaMusicManager() {
        setAllToEmpty();
    }

    private void setAllToEmpty() {
        reset();

    }

    public void reset() {
        this.situations = new HashSet<>();
        this.daytime = Daytime.NONAPPLICABLE;
        this.exactBiome = null;
        this.biomeTagIntersection = new HashSet<>();
        this.biomesSurrounding = new HashSet<>();
        this.songPool = new HashMap<>();
    }

    public HashSet<SituationalType> getSituations() {
        return situations;
    }

    public Daytime getDaytime() {
        return daytime;
    }

    public class_6880<class_1959> getExactBiome() {
        return exactBiome;
    }

    public HashSet<class_6862<class_1959>> getBiomeTagIntersection() {
        return biomeTagIntersection;
    }

    public HashSet<class_6880<class_1959>> getBiomesSurrounding() {
        return biomesSurrounding;
    }

    public HashMap<class_5195, Integer> getSongPool() {
        return songPool;
    }

    public Map<MusicEntry, Set<class_2960>> getUsableEntries() {
        return usableEntries;
    }

    public void addSituation(SituationalType situation) {
        this.situations.add(situation);
    }

    public void setDaytime(long daytime) {
        this.daytime = Daytime.getDaytime(daytime);
    }

    public void setExactBiome(class_6880<class_1959> exactBiome) {
        this.exactBiome = exactBiome;
    }

    public void setBiomeTagIntersection(HashSet<class_6862<class_1959>> biomeTagIntersection) {
        this.biomeTagIntersection = biomeTagIntersection;
    }

    public void addBiomesSurrounding(HashSet<class_6880<class_1959>> biomesSurrounding) {
        this.biomesSurrounding.addAll(biomesSurrounding);
    }

    public void addBiomesSurrounding(class_6880<class_1959> biomesSurrounding) {
        this.biomesSurrounding.add(biomesSurrounding);
    }

    public void deductSituations(class_1937 world, class_746 player) {
        if (world.method_27983() == class_1937.field_25181) {
            if (class_310.method_1551().field_1705.method_1740().method_1798()) {
                addSituation(SituationalType.DRAGON);
            } else {
                addSituation(SituationalType.END);
            }
        }
        if (world.method_27983() != class_1937.field_25180 && player.method_31549().field_7477 && player.method_31549().field_7478) {
            addSituation(SituationalType.CREATIVE);
        }
        if (player.method_5869()) {
            //TODO: better underwater detection
            addSituation(SituationalType.UNDERWATER);
        }

        //TODO: This is crude, might be better to work with POI or structure but it's not accessible on client
        Iterable<class_1297> listOfEntities = ((class_638) world).method_18112();
        for (class_1297 renderedEntity : listOfEntities) {
            if (renderedEntity instanceof class_1646 v && v.method_5739(player) <= 10f) {
                addSituation(SituationalType.VILLAGE);
            }
        }
    }

    /**
     * @return if the usableEntries actually changed from before
     */
    public boolean collectUsableEntries() {
        Map<MusicEntry, Set<class_2960>> newUsableEntries = new HashMap<>();

        if (!biomesSurrounding.isEmpty()) {
            newUsableEntries = MusicDataLoader.INSTANCE.biomeTagMap.entrySet().stream()
                    .filter(entry ->
                            biomeTagIntersection.contains(((BiomeTagMusicEntry) entry.getKey()).getTagKey()))
                    .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        if (exactBiome != null) {
            newUsableEntries.putAll(MusicDataLoader.INSTANCE.biomeMap.entrySet().stream()
                    .filter(entry ->
                            exactBiome.equals(((BiomeMusicEntry) entry.getKey()).getBiomeRef()))
                    .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))
            );
        }

        if (!situations.isEmpty()) {
            newUsableEntries.putAll(MusicDataLoader.INSTANCE.situationalMap.entrySet().stream()
                    .filter(entry ->
                            situations.contains(((SituationalMusicEntry) entry.getKey()).getSituation()))
                    .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))
            );
        }

        if (daytime != Daytime.NONAPPLICABLE) {
            newUsableEntries.putAll(MusicDataLoader.INSTANCE.daytimeMap.entrySet().stream()
                    .filter(entry ->
                            daytime.equals(((DaytimeMusicEntry) entry.getKey()).getDaytime()))
                    .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))
            );
        }

//        if(newUsableEntries.equals(usableEntries)){
//            return false;
//        }
        usableEntries = newUsableEntries;
        return true;
    }

    public class_10383 getRandomMusicInstance() {
        //return new MusicInstance(MusicType.UNDERWATER, 1);
        class_5195 selection = getRandomWeightedElement(songPool);
        if (selection == null) selection = new class_5195(class_7923.field_41172.method_47983(class_3417.field_42593), 10, 10, false);
        return new class_10383(selection, 1f);
    }

    public void putMusicEntry(MusicEntry musicEntry, Set<class_2960> songEvents) {
        for (class_2960 songEvent : songEvents) {
            class_5195 musicType = musicEntry.getMusicType(songEvent);
            int weight = musicEntry.getWeight();

            if (!songPool.containsKey(musicType)) {
                songPool.put(musicType, weight);
            } else {
                songPool.put(musicType, songPool.get(musicType) + weight);
            }
        }
    }

    /**
     *
     * @param objects: A Map containing the objects to choose from, where the keys represent the objects and the values represent their respective weights.
     * @param <T>      A randomly selected element from the Map, or null if the Map is empty.
     *                           TODO: this assumes positive values for weight
     * @return Returns a randomly selected element from a Map, with selection probabilities proportional to each element's weight.
     */
    public <T> T getRandomWeightedElement(Map<T, Integer> objects) {
        if (objects.isEmpty()) return null;

        int sum = objects.values().stream().mapToInt(Integer::intValue).sum();
        int random = randomInstance.method_43048(sum);
        for (T item : objects.keySet()) {
            random -= objects.get(item);
            if (random < 0) {
                return item;
            }
        }
        return null;
    }
}
