package mod.crontent.music.management.loading;

import mod.crontent.Utils;
import mod.crontent.music.definition.MusicDefinition;
import mod.crontent.music.definition.entries.*;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6862;
import net.minecraft.class_7654;
import java.util.*;

public class MusicDataLoader extends class_4309<MusicDefinition> {
    public static final MusicDataLoader INSTANCE = new MusicDataLoader();
    public static final class_2960 ID = Utils.id("music_definition_manager");
    public static final String DATA_TYPE = "music_definitions";

    private Map<class_2960, MusicDefinition> musicDefinitions;
    //Identifier here is the Sound event id
    //TODO: this should prolly be private and gotten via getter
    public final Map<MusicEntry, Set<class_2960>> biomeMap = new HashMap<>();
    public final Map<MusicEntry, Set<class_2960>> biomeTagMap = new HashMap<>();
    public final Map<MusicEntry, Set<class_2960>> situationalMap = new HashMap<>();
    public final Map<MusicEntry, Set<class_2960>> daytimeMap = new HashMap<>();

    public final Map<MusicEntry, Set<class_2960>> generatedBiomeMap = new HashMap<>();
    public final Map<MusicEntry, Set<class_2960>> generatedBiomeTagMap = new HashMap<>();
    public final Map<MusicEntry, Set<class_2960>> generatedSituationalMap = new HashMap<>();

    public final Set<class_6862<class_1959>> definedTagKeys = new HashSet<>();


    public MusicDataLoader() {
        super(MusicDefinition.CODEC, class_7654.method_45114(DATA_TYPE));
    }

    @Override
    public void apply(Map<class_2960, MusicDefinition> prepared, class_3300 manager, class_3695 profiler) {
        musicDefinitions = Map.copyOf(prepared);
        calcReverseMap();
    }

    private void calcReverseMap() {
        biomeMap.clear();
        biomeMap.putAll(generatedBiomeMap);

        biomeTagMap.clear();
        biomeTagMap.putAll(generatedBiomeTagMap);
        definedTagKeys.clear();

        situationalMap.clear();
        situationalMap.putAll(generatedSituationalMap);

        daytimeMap.clear();
        musicDefinitions.forEach((identifier, musicDefinition) ->
        {
            musicDefinition.playConditions().forEach(currentEntry ->
            {
                if(currentEntry.getType().equals(MusicEntryTypes.BIOME)){
                    putCurrentEntryAndId(biomeMap, identifier, currentEntry);
                }else if(currentEntry.getType().equals(MusicEntryTypes.BIOME_TAG)){
                    putCurrentEntryAndId(biomeTagMap, identifier, currentEntry);
                    definedTagKeys.add(((BiomeTagMusicEntry) currentEntry).getTagKey());
                }else if(currentEntry.getType().equals(MusicEntryTypes.SITUATIONAL)){
                    putCurrentEntryAndId(situationalMap, identifier, currentEntry);
                }else if(currentEntry.getType().equals(MusicEntryTypes.DAYTIME)){
                    putCurrentEntryAndId(daytimeMap, identifier, currentEntry);
                }
            });
        });
    }

    private static void putCurrentEntryAndId(Map<MusicEntry, Set<class_2960>> map, class_2960 id, MusicEntry currentEntry) {
        map.computeIfAbsent(currentEntry, musicEntry -> new HashSet<>());
        map.get(currentEntry).add(id);
    }

    public void putIntoGenTag(class_2960 id, MusicEntry entry){
        switch(entry){
            case BiomeTagMusicEntry castEntry -> putCurrentEntryAndId(generatedBiomeTagMap, id, castEntry);
            case SituationalMusicEntry castEntry -> putCurrentEntryAndId(generatedSituationalMap, id, castEntry);
            case BiomeMusicEntry castEntry -> putCurrentEntryAndId(generatedBiomeMap, id, castEntry);
            default -> throw new IllegalStateException("Unexpected value: " + entry);
        }
    }


    public boolean contains(class_2960 id){
        return musicDefinitions.containsKey(id);
    }

    public MusicDefinition get(class_2960 id){
        MusicDefinition d = musicDefinitions.get(id);
        if (d == null) {
            throw new IllegalArgumentException("Cannot find music definition for '%s', it will not play".formatted(id));
        }
        return d;
    }

    public Set<class_2960> getKeySet() {
        return musicDefinitions.keySet();
    }


}
