package mod.crontent.music.management.loading.converting;

import mod.crontent.interfaces.SoundListAccess;
import mod.crontent.interfaces.WeightedSoundSetAccess;
import mod.crontent.mixin.client.SoundManagerAnonymousClassMixin;
import mod.crontent.music.definition.entries.BiomeTagMusicEntry;
import mod.crontent.music.definition.entries.MusicEntry;
import mod.crontent.music.definition.entries.SituationalMusicEntry;
import mod.crontent.music.management.loading.MusicDataLoader;
import net.minecraft.class_1111;
import net.minecraft.class_1146;
import net.minecraft.class_1148;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Unique;

public class SoundEventConverter {

    //TODO: Take into account actual weight as defined in the sound
    public static void processSoundsForConversion(SoundListAccess original) {
        original.volume_gamma$getLoadedSounds().forEach((identifier, weightedSoundSet) -> {
            if (identifier.method_12832().startsWith("music.")) {
                if (identifier.equals(class_2960.method_60654("music.game"))) {
                    ((WeightedSoundSetAccess) weightedSoundSet).volume_gamma$getSounds()
                            .forEach(soundSoundContainer -> processSoundEvent(soundSoundContainer, new BiomeTagMusicEntry(1, "c:is_overworld"))
                            );
                } else if (identifier.equals(class_2960.method_60654("music.menu"))) {
                    ((WeightedSoundSetAccess) weightedSoundSet).volume_gamma$getSounds()
                            .forEach(soundSoundContainer -> processSoundEvent(soundSoundContainer, new SituationalMusicEntry(1, "MENU"))
                            );
                } else if (identifier.equals(class_2960.method_60654("music.creative"))) {
                    ((WeightedSoundSetAccess) weightedSoundSet).volume_gamma$getSounds()
                            .forEach(soundSoundContainer -> processSoundEvent(soundSoundContainer, new SituationalMusicEntry(1, "CREATIVE"))
                            );
                } else if (identifier.equals(class_2960.method_60654("music.under_water"))) {
                    ((WeightedSoundSetAccess) weightedSoundSet).volume_gamma$getSounds()
                            .forEach(soundSoundContainer -> processSoundEvent(soundSoundContainer, new SituationalMusicEntry(1, "UNDERWATER"))
                            );
                }else if (identifier.equals(class_2960.method_60654("music.dragon"))) {
                    ((WeightedSoundSetAccess) weightedSoundSet).volume_gamma$getSounds()
                            .forEach(soundSoundContainer -> processSoundEvent(soundSoundContainer, new SituationalMusicEntry(1, "DRAGON"))
                            );
                }else if (identifier.equals(class_2960.method_60654("music.end"))) {
                    ((WeightedSoundSetAccess) weightedSoundSet).volume_gamma$getSounds()
                            .forEach(soundSoundContainer -> processSoundEvent(soundSoundContainer, new SituationalMusicEntry(1, "END"))
                            );
                }else if (identifier.method_12832().startsWith("music.")){
                    String biomePart = identifier.method_12832().substring(identifier.method_12832().lastIndexOf("music.") + 6);
                    //TODO: implement logic for biome based musics
                    //This is accomplished with custom music defs for now
                }
            }
        });
    }

    private static <T extends MusicEntry> void processSoundEvent(class_1148<class_1111> soundSoundContainer, T entry) {
        if (soundSoundContainer instanceof class_1111 sound) {
            buildAndPut(entry, sound);
        } else //noinspection ReferenceToMixin
            if (soundSoundContainer instanceof SoundManagerAnonymousClassMixin song) {
            if (song.volume_gamma$field_5595().method_4768() == class_1111.class_1112.field_5473) {
                //TODO: can we be sure at this point that the sound event that is asked for exists?
                class_1146 soundEventSet = ((SoundListAccess) song.volume_gamma$field_5597()).volume_gamma$getLoadedSounds().get(song.volume_gamma$field_5595().method_4767());
                ((WeightedSoundSetAccess) soundEventSet).volume_gamma$getSounds().forEach(soundContainer -> {
                    if (soundContainer instanceof class_1111 sound) {
                        buildAndPut(entry, sound);
                    }
                });

//                                        Map<Identifier, WeightedSoundSet> filtered = ((SoundListAccess) song.volume_gamma$field_5597()).getLoadedSounds().entrySet()
//                                                .stream()
//                                                .filter(identifierWeightedSoundSetEntry ->
//                                                    identifierWeightedSoundSetEntry.getKey().equals(song.volume_gamma$field_5595().getIdentifier()))
//                                                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
//                                        System.out.println(filtered);
            }
        }
    }

    private static <T extends MusicEntry> void buildAndPut(T entry, class_1111 sound) {
        class_2960 fullSongId = sound.method_4765(class_5819.method_43047()).method_4767();
        String[] nameParts = fullSongId.method_12832().split("/");
        String songName = nameParts[nameParts.length - 1];
        entry.setWeight(sound.method_4894());
        MusicDataLoader.INSTANCE.putIntoGenTag(class_2960.method_60655(fullSongId.method_12836(), songName), entry);
    }
}
