/*
 * Decompiled with CFR 0.152.
 */
package mod.crontent.mixin.client;

import java.util.ArrayList;
import java.util.HashSet;
import mod.crontent.Utils;
import mod.crontent.interfaces.ChunkBiomeCounterAccess;
import mod.crontent.interfaces.MusicStuffAccess;
import mod.crontent.music.management.GammaMusicManager;
import mod.crontent.music.management.MusicManagerEnums;
import mod.crontent.music.management.loading.BiomeTagMapper;
import mod.crontent.music.management.loading.MusicDataLoader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_10383;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8144;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_310.class})
public abstract class MinecraftClientMixin
implements MusicStuffAccess {
    @Shadow
    @Nullable
    public class_638 field_1687;
    @Unique
    class_10383 currentMusicInstance = new class_10383(new class_5195(class_7923.field_41172.method_47983((Object)class_3417.field_42593), 10, 10, false));

    @Override
    public HashSet<MusicManagerEnums.SituationalType> volume_gamma$getCurrentSituations() {
        return GammaMusicManager.INSTANCE.getSituations();
    }

    @Override
    public MusicManagerEnums.Daytime volume_gamma$getCurrentDaytime() {
        return GammaMusicManager.INSTANCE.getDaytime();
    }

    @Override
    public class_6880<class_1959> volume_gamma$getCurrentExactBiome() {
        return GammaMusicManager.INSTANCE.getExactBiome();
    }

    @Override
    public HashSet<class_6862<class_1959>> volume_gamma$getCurrentSurroundingBiomeTagsIntersection() {
        return GammaMusicManager.INSTANCE.getBiomeTagIntersection();
    }

    @Override
    public HashSet<class_6880<class_1959>> volume_gamma$getCurrentSurroundingBiomes() {
        return GammaMusicManager.INSTANCE.getBiomesSurrounding();
    }

    @Override
    public GammaMusicManager volume_gamma$getMusicManager() {
        return GammaMusicManager.INSTANCE;
    }

    @Override
    public class_10383 volume_gamma$getCurrentMusicInstance() {
        return this.currentMusicInstance;
    }

    @Overwrite
    public class_10383 method_1544() {
        class_5195 musicSound = (class_5195)class_8144.method_49077((Object)((class_310)this).field_1755, class_437::method_50024);
        if (musicSound != null) {
            return new class_10383(musicSound);
        }
        this.fillPlayConditions();
        GammaMusicManager.INSTANCE.collectUsableEntries();
        GammaMusicManager.INSTANCE.getUsableEntries().forEach(GammaMusicManager.INSTANCE::putMusicEntry);
        this.currentMusicInstance = GammaMusicManager.INSTANCE.getRandomMusicInstance();
        return this.currentMusicInstance;
    }

    @Unique
    private void fillPlayConditions() {
        GammaMusicManager.INSTANCE.reset();
        if (((class_310)this).field_1724 != null) {
            class_746 player = ((class_310)this).field_1724;
            class_1937 world = player.method_73183();
            if (world.method_27983() == class_1937.field_25179) {
                GammaMusicManager.INSTANCE.setDaytime(world.method_8532());
            } else {
                GammaMusicManager.INSTANCE.setDaytime(-1L);
            }
            GammaMusicManager.INSTANCE.deductSituations(world, player);
            GammaMusicManager.INSTANCE.setExactBiome((class_6880<class_1959>)world.method_23753(player.method_24515()));
            class_1923 currentChunkPos = world.method_22350(player.method_24515()).method_12004();
            int radius = 2;
            for (int x = currentChunkPos.field_9181 - radius; x <= currentChunkPos.field_9181 + radius; ++x) {
                for (int z = currentChunkPos.field_9180 - radius; z <= currentChunkPos.field_9180 + radius; ++z) {
                    HashSet<class_6880<class_1959>> present = ((ChunkBiomeCounterAccess)world.method_8497(x, z)).gamma$getBiomesPresent();
                    present.removeIf(biomeRegistryEntry -> biomeRegistryEntry.method_40220(ConventionalBiomeTags.IS_CAVE));
                    GammaMusicManager.INSTANCE.addBiomesSurrounding(present);
                }
            }
            ArrayList surroundingBiomeTags = new ArrayList();
            GammaMusicManager.INSTANCE.getBiomesSurrounding().forEach(biomeRegistryEntry -> {
                HashSet<class_6862<class_1959>> tags = BiomeTagMapper.lookup((class_6880<class_1959>)biomeRegistryEntry);
                surroundingBiomeTags.add(tags);
            });
            HashSet<class_6862<class_1959>> biomeTagIntersection = Utils.findIntersection(new HashSet(), surroundingBiomeTags.toArray(new HashSet[0]));
            for (class_6862 class_68622 : biomeTagIntersection) {
                class_6862 overworldTag;
                if (class_68622.equals((Object)(overworldTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"c", (String)"is_overworld")))) || !MusicDataLoader.INSTANCE.definedTagKeys.contains(class_68622)) continue;
                biomeTagIntersection.remove(overworldTag);
                break;
            }
            GammaMusicManager.INSTANCE.setBiomeTagIntersection(biomeTagIntersection);
        } else {
            GammaMusicManager.INSTANCE.addSituation(MusicManagerEnums.SituationalType.MENU);
        }
    }
}

