/*
 * Decompiled with CFR 0.152.
 */
package mod.crontent.music.definition.entries;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.Optional;
import mod.crontent.VolumeGammaClient;
import mod.crontent.music.definition.entries.MusicEntryType;
import mod.crontent.music.definition.entries.SituationalMusicEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5195;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public abstract class MusicEntry<T> {
    public static final int DEFAULT_WEIGHT = 3;
    protected int weight;
    protected final String name;
    public static final Codec<MusicEntry> CODEC = MusicEntryType.REGISTRY.method_39673().dispatch(MusicEntry::getType, MusicEntryType::codec);

    public MusicEntry(String name) {
        this.weight = 3;
        this.name = name;
    }

    public MusicEntry(int weight, String name) {
        this.weight = weight;
        this.name = name;
    }

    public abstract MusicEntryType<?> getType();

    public abstract boolean matchesGivenCondition(T var1);

    public class_2960 getId() {
        return class_2960.method_60654((String)this.name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof MusicEntry)) return false;
        MusicEntry otherEntry = (MusicEntry)obj;
        if (!otherEntry.name.equals(this.name)) return false;
        if (otherEntry.weight != this.weight) return false;
        if (!otherEntry.getType().equals(this.getType())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.weight, this.getType());
    }

    public String getName() {
        return this.name;
    }

    public int getWeight() {
        return this.weight;
    }

    public class_5195 getMusicType(class_2960 id) {
        class_2960 prefixedId = class_2960.method_60655((String)id.method_12836(), (String)"music.".concat(id.method_12832()));
        class_6880<class_3414> soundEvent = MusicEntry.getSoundEventRegistryEntry(prefixedId);
        class_5195 ms = new class_5195(soundEvent, 12000, 24000, false);
        MusicEntry musicEntry = this;
        if (musicEntry instanceof SituationalMusicEntry) {
            SituationalMusicEntry e = (SituationalMusicEntry)musicEntry;
            switch (e.getSituation()) {
                case MENU: {
                    ms = new class_5195(soundEvent, 20, 600, true);
                    break;
                }
                case CREDITS: {
                    new class_5195(soundEvent, 0, 0, true);
                    break;
                }
                case DRAGON: {
                    new class_5195(soundEvent, 0, 0, true);
                    break;
                }
                case END: {
                    new class_5195(soundEvent, 6000, 24000, true);
                }
            }
        }
        return ms;
    }

    @NotNull
    public static class_6880<class_3414> getSoundEventRegistryEntry(class_2960 id) {
        Optional entry = class_7923.field_41172.method_10223(id);
        if (entry.isEmpty()) {
            VolumeGammaClient.LOGGER.warn("Sound Entry of ID {} is nonexistant.", (Object)id);
        }
        return entry.isPresent() ? (class_6880)entry.get() : class_7923.field_41172.method_47983((Object)class_3417.field_42593);
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }
}

