/*
 * Decompiled with CFR 0.152.
 */
package mod.crontent.music.management;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.crontent.music.definition.entries.BiomeMusicEntry;
import mod.crontent.music.definition.entries.BiomeTagMusicEntry;
import mod.crontent.music.definition.entries.DaytimeMusicEntry;
import mod.crontent.music.definition.entries.MusicEntry;
import mod.crontent.music.definition.entries.SituationalMusicEntry;
import mod.crontent.music.management.MusicManagerEnums;
import mod.crontent.music.management.loading.MusicDataLoader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_10383;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class GammaMusicManager {
    public static final GammaMusicManager INSTANCE = new GammaMusicManager();
    private final class_5819 randomInstance = class_5819.method_43047();
    HashSet<MusicManagerEnums.SituationalType> situations;
    MusicManagerEnums.Daytime daytime;
    class_6880<class_1959> exactBiome;
    HashSet<class_6862<class_1959>> biomeTagIntersection = new HashSet();
    HashSet<class_6880<class_1959>> biomesSurrounding = new HashSet();
    private Map<MusicEntry, Set<class_2960>> usableEntries = new HashMap<MusicEntry, Set<class_2960>>();
    Predicate<class_6880<class_1959>> shouldBiomeIncludedInTags = biome -> !biome.method_40220(ConventionalBiomeTags.IS_CAVE);
    public HashMap<class_5195, Integer> songPool;

    public GammaMusicManager() {
        this.setAllToEmpty();
    }

    private void setAllToEmpty() {
        this.reset();
    }

    public void reset() {
        this.situations = new HashSet();
        this.daytime = MusicManagerEnums.Daytime.NONAPPLICABLE;
        this.exactBiome = null;
        this.biomeTagIntersection = new HashSet();
        this.biomesSurrounding = new HashSet();
        this.songPool = new HashMap();
    }

    public HashSet<MusicManagerEnums.SituationalType> getSituations() {
        return this.situations;
    }

    public MusicManagerEnums.Daytime getDaytime() {
        return this.daytime;
    }

    public class_6880<class_1959> getExactBiome() {
        return this.exactBiome;
    }

    public HashSet<class_6862<class_1959>> getBiomeTagIntersection() {
        return this.biomeTagIntersection;
    }

    public HashSet<class_6880<class_1959>> getBiomesSurrounding() {
        return this.biomesSurrounding;
    }

    public HashMap<class_5195, Integer> getSongPool() {
        return this.songPool;
    }

    public Map<MusicEntry, Set<class_2960>> getUsableEntries() {
        return this.usableEntries;
    }

    public void addSituation(MusicManagerEnums.SituationalType situation) {
        this.situations.add(situation);
    }

    public void setDaytime(long daytime) {
        this.daytime = MusicManagerEnums.Daytime.getDaytime(daytime);
    }

    public void setExactBiome(class_6880<class_1959> exactBiome) {
        this.exactBiome = exactBiome;
    }

    public void setBiomeTagIntersection(HashSet<class_6862<class_1959>> biomeTagIntersection) {
        this.biomeTagIntersection = biomeTagIntersection;
    }

    public void addBiomesSurrounding(HashSet<class_6880<class_1959>> biomesSurrounding) {
        this.biomesSurrounding.addAll(biomesSurrounding);
    }

    public void addBiomesSurrounding(class_6880<class_1959> biomesSurrounding) {
        this.biomesSurrounding.add(biomesSurrounding);
    }

    public void deductSituations(class_1937 world, class_746 player) {
        if (world.method_27983() == class_1937.field_25181) {
            if (class_310.method_1551().field_1705.method_1740().method_1798()) {
                this.addSituation(MusicManagerEnums.SituationalType.DRAGON);
            } else {
                this.addSituation(MusicManagerEnums.SituationalType.END);
            }
        }
        if (world.method_27983() != class_1937.field_25180 && player.method_31549().field_7477 && player.method_31549().field_7478) {
            this.addSituation(MusicManagerEnums.SituationalType.CREATIVE);
        }
        if (player.method_5869()) {
            this.addSituation(MusicManagerEnums.SituationalType.UNDERWATER);
        }
        Iterable listOfEntities = ((class_638)world).method_18112();
        for (class_1297 renderedEntity : listOfEntities) {
            class_1646 v;
            if (!(renderedEntity instanceof class_1646) || !((v = (class_1646)renderedEntity).method_5739((class_1297)player) <= 10.0f)) continue;
            this.addSituation(MusicManagerEnums.SituationalType.VILLAGE);
        }
    }

    public boolean collectUsableEntries() {
        Map<MusicEntry, Set> newUsableEntries = new HashMap<MusicEntry, Set>();
        if (!this.biomesSurrounding.isEmpty()) {
            newUsableEntries = MusicDataLoader.INSTANCE.biomeTagMap.entrySet().stream().filter(entry -> this.biomeTagIntersection.contains(((BiomeTagMusicEntry)entry.getKey()).getTagKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (this.exactBiome != null) {
            newUsableEntries.putAll(MusicDataLoader.INSTANCE.biomeMap.entrySet().stream().filter(entry -> this.exactBiome.equals(((BiomeMusicEntry)entry.getKey()).getBiomeRef())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (!this.situations.isEmpty()) {
            newUsableEntries.putAll(MusicDataLoader.INSTANCE.situationalMap.entrySet().stream().filter(entry -> this.situations.contains((Object)((SituationalMusicEntry)entry.getKey()).getSituation())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (this.daytime != MusicManagerEnums.Daytime.NONAPPLICABLE) {
            newUsableEntries.putAll(MusicDataLoader.INSTANCE.daytimeMap.entrySet().stream().filter(entry -> this.daytime.equals((Object)((DaytimeMusicEntry)entry.getKey()).getDaytime())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        this.usableEntries = newUsableEntries;
        return true;
    }

    public class_10383 getRandomMusicInstance() {
        class_5195 selection = this.getRandomWeightedElement(this.songPool);
        if (selection == null) {
            selection = new class_5195(class_7923.field_41172.method_47983((Object)class_3417.field_42593), 10, 10, false);
        }
        return new class_10383(selection, 1.0f);
    }

    public void putMusicEntry(MusicEntry musicEntry, Set<class_2960> songEvents) {
        for (class_2960 songEvent : songEvents) {
            class_5195 musicType = musicEntry.getMusicType(songEvent);
            int weight = musicEntry.getWeight();
            if (!this.songPool.containsKey(musicType)) {
                this.songPool.put(musicType, weight);
                continue;
            }
            this.songPool.put(musicType, this.songPool.get(musicType) + weight);
        }
    }

    public <T> T getRandomWeightedElement(Map<T, Integer> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        int sum = objects.values().stream().mapToInt(Integer::intValue).sum();
        int random = this.randomInstance.method_43048(sum);
        for (T item : objects.keySet()) {
            if ((random -= objects.get(item).intValue()) >= 0) continue;
            return item;
        }
        return null;
    }
}

