/*
 * Decompiled with CFR 0.152.
 */
package mod.crontent.music.management.loading;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mod.crontent.Utils;
import mod.crontent.music.definition.MusicDefinition;
import mod.crontent.music.definition.entries.BiomeMusicEntry;
import mod.crontent.music.definition.entries.BiomeTagMusicEntry;
import mod.crontent.music.definition.entries.MusicEntry;
import mod.crontent.music.definition.entries.MusicEntryTypes;
import mod.crontent.music.definition.entries.SituationalMusicEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6862;
import net.minecraft.class_7654;

@Environment(value=EnvType.CLIENT)
public class MusicDataLoader
extends class_4309<MusicDefinition> {
    public static final MusicDataLoader INSTANCE = new MusicDataLoader();
    public static final class_2960 ID = Utils.id("music_definition_manager");
    public static final String DATA_TYPE = "music_definitions";
    private Map<class_2960, MusicDefinition> musicDefinitions;
    public final Map<MusicEntry, Set<class_2960>> biomeMap = new HashMap<MusicEntry, Set<class_2960>>();
    public final Map<MusicEntry, Set<class_2960>> biomeTagMap = new HashMap<MusicEntry, Set<class_2960>>();
    public final Map<MusicEntry, Set<class_2960>> situationalMap = new HashMap<MusicEntry, Set<class_2960>>();
    public final Map<MusicEntry, Set<class_2960>> daytimeMap = new HashMap<MusicEntry, Set<class_2960>>();
    public final Map<MusicEntry, Set<class_2960>> generatedBiomeMap = new HashMap<MusicEntry, Set<class_2960>>();
    public final Map<MusicEntry, Set<class_2960>> generatedBiomeTagMap = new HashMap<MusicEntry, Set<class_2960>>();
    public final Map<MusicEntry, Set<class_2960>> generatedSituationalMap = new HashMap<MusicEntry, Set<class_2960>>();
    public final Set<class_6862<class_1959>> definedTagKeys = new HashSet<class_6862<class_1959>>();

    public MusicDataLoader() {
        super(MusicDefinition.CODEC, class_7654.method_45114((String)DATA_TYPE));
    }

    public void apply(Map<class_2960, MusicDefinition> prepared, class_3300 manager, class_3695 profiler) {
        this.musicDefinitions = Map.copyOf(prepared);
        this.calcReverseMap();
    }

    private void calcReverseMap() {
        this.biomeMap.clear();
        this.biomeMap.putAll(this.generatedBiomeMap);
        this.biomeTagMap.clear();
        this.biomeTagMap.putAll(this.generatedBiomeTagMap);
        this.definedTagKeys.clear();
        this.situationalMap.clear();
        this.situationalMap.putAll(this.generatedSituationalMap);
        this.daytimeMap.clear();
        this.musicDefinitions.forEach((identifier, musicDefinition) -> musicDefinition.playConditions().forEach(currentEntry -> {
            if (currentEntry.getType().equals(MusicEntryTypes.BIOME)) {
                MusicDataLoader.putCurrentEntryAndId(this.biomeMap, identifier, currentEntry);
            } else if (currentEntry.getType().equals(MusicEntryTypes.BIOME_TAG)) {
                MusicDataLoader.putCurrentEntryAndId(this.biomeTagMap, identifier, currentEntry);
                this.definedTagKeys.add(((BiomeTagMusicEntry)currentEntry).getTagKey());
            } else if (currentEntry.getType().equals(MusicEntryTypes.SITUATIONAL)) {
                MusicDataLoader.putCurrentEntryAndId(this.situationalMap, identifier, currentEntry);
            } else if (currentEntry.getType().equals(MusicEntryTypes.DAYTIME)) {
                MusicDataLoader.putCurrentEntryAndId(this.daytimeMap, identifier, currentEntry);
            }
        }));
    }

    private static void putCurrentEntryAndId(Map<MusicEntry, Set<class_2960>> map, class_2960 id, MusicEntry currentEntry) {
        map.computeIfAbsent(currentEntry, musicEntry -> new HashSet());
        map.get(currentEntry).add(id);
    }

    public void putIntoGenTag(class_2960 id, MusicEntry entry) {
        MusicEntry musicEntry = entry;
        Objects.requireNonNull(musicEntry);
        MusicEntry musicEntry2 = musicEntry;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BiomeTagMusicEntry.class, SituationalMusicEntry.class, BiomeMusicEntry.class}, (Object)musicEntry2, n)) {
            case 0: {
                BiomeTagMusicEntry castEntry = (BiomeTagMusicEntry)musicEntry2;
                MusicDataLoader.putCurrentEntryAndId(this.generatedBiomeTagMap, id, castEntry);
                break;
            }
            case 1: {
                SituationalMusicEntry castEntry = (SituationalMusicEntry)musicEntry2;
                MusicDataLoader.putCurrentEntryAndId(this.generatedSituationalMap, id, castEntry);
                break;
            }
            case 2: {
                BiomeMusicEntry castEntry = (BiomeMusicEntry)musicEntry2;
                MusicDataLoader.putCurrentEntryAndId(this.generatedBiomeMap, id, castEntry);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(entry));
            }
        }
    }

    public boolean contains(class_2960 id) {
        return this.musicDefinitions.containsKey(id);
    }

    public MusicDefinition get(class_2960 id) {
        MusicDefinition d = this.musicDefinitions.get(id);
        if (d == null) {
            throw new IllegalArgumentException("Cannot find music definition for '%s', it will not play".formatted(id));
        }
        return d;
    }

    public Set<class_2960> getKeySet() {
        return this.musicDefinitions.keySet();
    }
}

