/*
 * Decompiled with CFR 0.152.
 */
package mod.crontent.music.management.loading.converting;

import mod.crontent.interfaces.SoundListAccess;
import mod.crontent.interfaces.WeightedSoundSetAccess;
import mod.crontent.mixin.client.SoundManagerAnonymousClassMixin;
import mod.crontent.music.definition.entries.BiomeTagMusicEntry;
import mod.crontent.music.definition.entries.MusicEntry;
import mod.crontent.music.definition.entries.SituationalMusicEntry;
import mod.crontent.music.management.loading.MusicDataLoader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1111;
import net.minecraft.class_1146;
import net.minecraft.class_1148;
import net.minecraft.class_2960;
import net.minecraft.class_5819;

@Environment(value=EnvType.CLIENT)
public class SoundEventConverter {
    public static void processSoundsForConversion(SoundListAccess original) {
        original.volume_gamma$getLoadedSounds().forEach((identifier, weightedSoundSet) -> {
            if (identifier.method_12832().startsWith("music.")) {
                if (identifier.equals((Object)class_2960.method_60654((String)"music.game"))) {
                    ((WeightedSoundSetAccess)weightedSoundSet).volume_gamma$getSounds().forEach(soundSoundContainer -> SoundEventConverter.processSoundEvent((class_1148<class_1111>)soundSoundContainer, new BiomeTagMusicEntry(1, "c:is_overworld")));
                } else if (identifier.equals((Object)class_2960.method_60654((String)"music.menu"))) {
                    ((WeightedSoundSetAccess)weightedSoundSet).volume_gamma$getSounds().forEach(soundSoundContainer -> SoundEventConverter.processSoundEvent((class_1148<class_1111>)soundSoundContainer, new SituationalMusicEntry(1, "MENU")));
                } else if (identifier.equals((Object)class_2960.method_60654((String)"music.creative"))) {
                    ((WeightedSoundSetAccess)weightedSoundSet).volume_gamma$getSounds().forEach(soundSoundContainer -> SoundEventConverter.processSoundEvent((class_1148<class_1111>)soundSoundContainer, new SituationalMusicEntry(1, "CREATIVE")));
                } else if (identifier.equals((Object)class_2960.method_60654((String)"music.under_water"))) {
                    ((WeightedSoundSetAccess)weightedSoundSet).volume_gamma$getSounds().forEach(soundSoundContainer -> SoundEventConverter.processSoundEvent((class_1148<class_1111>)soundSoundContainer, new SituationalMusicEntry(1, "UNDERWATER")));
                } else if (identifier.equals((Object)class_2960.method_60654((String)"music.dragon"))) {
                    ((WeightedSoundSetAccess)weightedSoundSet).volume_gamma$getSounds().forEach(soundSoundContainer -> SoundEventConverter.processSoundEvent((class_1148<class_1111>)soundSoundContainer, new SituationalMusicEntry(1, "DRAGON")));
                } else if (identifier.equals((Object)class_2960.method_60654((String)"music.end"))) {
                    ((WeightedSoundSetAccess)weightedSoundSet).volume_gamma$getSounds().forEach(soundSoundContainer -> SoundEventConverter.processSoundEvent((class_1148<class_1111>)soundSoundContainer, new SituationalMusicEntry(1, "END")));
                } else if (identifier.method_12832().startsWith("music.")) {
                    String string = identifier.method_12832().substring(identifier.method_12832().lastIndexOf("music.") + 6);
                }
            }
        });
    }

    private static <T extends MusicEntry> void processSoundEvent(class_1148<class_1111> soundSoundContainer, T entry) {
        SoundManagerAnonymousClassMixin song;
        if (soundSoundContainer instanceof class_1111) {
            class_1111 sound = (class_1111)soundSoundContainer;
            SoundEventConverter.buildAndPut(entry, sound);
        } else if (soundSoundContainer instanceof SoundManagerAnonymousClassMixin && (song = (SoundManagerAnonymousClassMixin)soundSoundContainer).volume_gamma$field_5595().method_4768() == class_1111.class_1112.field_5473) {
            class_1146 soundEventSet = ((SoundListAccess)song.volume_gamma$field_5597()).volume_gamma$getLoadedSounds().get(song.volume_gamma$field_5595().method_4767());
            ((WeightedSoundSetAccess)soundEventSet).volume_gamma$getSounds().forEach(soundContainer -> {
                if (soundContainer instanceof class_1111) {
                    class_1111 sound = (class_1111)soundContainer;
                    SoundEventConverter.buildAndPut(entry, sound);
                }
            });
        }
    }

    private static <T extends MusicEntry> void buildAndPut(T entry, class_1111 sound) {
        class_2960 fullSongId = sound.method_4765(class_5819.method_43047()).method_4767();
        String[] nameParts = fullSongId.method_12832().split("/");
        String songName = nameParts[nameParts.length - 1];
        entry.setWeight(sound.method_4894());
        MusicDataLoader.INSTANCE.putIntoGenTag(class_2960.method_60655((String)fullSongId.method_12836(), (String)songName), entry);
    }
}

