/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.farmers_attributes.event;

import medi.makiba.farmers_attributes.attribute.AntiFarmlandTrampling;
import medi.makiba.farmers_attributes.attribute.CrouchBoneMeal;
import medi.makiba.farmers_attributes.attribute.EasyHarvest;
import medi.makiba.farmers_attributes.attribute.GreenThumb;
import medi.makiba.farmers_attributes.attribute.ZestyCulinary;
import medi.makiba.farmers_attributes.registry.FAAttributes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="farmers_attributes")
public class FAEvents {
    @SubscribeEvent
    public static void modifyDefaultAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, FAAttributes.ANTI_FARMLAND_TRAMPLING);
        event.add(EntityType.PLAYER, FAAttributes.EASY_HARVEST);
        event.add(EntityType.PLAYER, FAAttributes.CROUCH_BONEMEAL_CHANCE);
        event.add(EntityType.PLAYER, FAAttributes.ZESTY_CULINARY);
        event.add(EntityType.PLAYER, FAAttributes.GREEN_THUMB);
        event.add(EntityType.PLAYER, FAAttributes.SHORT_ORDER_COOKING);
    }

    @SubscribeEvent
    public static void checkCancelTrample(BlockEvent.FarmlandTrampleEvent event) {
        ServerPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && AntiFarmlandTrampling.checkCancelTrample(player = (ServerPlayer)entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void tickCrouchBoneMeal(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        CrouchBoneMeal.tickCrouchBoneMeal((ServerLevel)event.getEntity().level(), (ServerPlayer)player);
    }

    @SubscribeEvent
    public static void craftZestyCulinary(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        Item item = event.getCrafting().getItem();
        if (item != null) {
            ZestyCulinary.applyAppetiteOnCrafting((ServerPlayer)player, new ItemStack((ItemLike)item));
        }
    }

    @SubscribeEvent
    public static void smeltZestyCulinary(PlayerEvent.ItemSmeltedEvent event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        Item item = event.getSmelting().getItem();
        if (item != null) {
            ZestyCulinary.applyAppetiteOnCrafting((ServerPlayer)player, new ItemStack((ItemLike)item));
        }
    }

    @SubscribeEvent
    public static void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)levelAccessor;
                ZestyCulinary.applyAppetiteAoeOnPlacement(livingEntity, level, event.getPos(), event.getPlacedBlock());
                GreenThumb.checkAndAddData(livingEntity, level, event.getPos());
            }
        }
    }

    @SubscribeEvent
    public static void checkEasyHarvestOnRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (EasyHarvest.tryHarvest(event.getLevel(), event.getPos(), event.getEntity(), event.getFace(), event.getItemStack())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getSide().isClient()));
        }
    }

    @SubscribeEvent
    public static void checkGreenThumbOnCropGrowth(CropGrowEvent.Post event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            GreenThumb.checkAndApplyGreenThumbOnGrowth(level, event.getPos(), event.getState());
        }
    }

    @SubscribeEvent
    public static void checkGreenThumbOnCropHarvest(BlockDropsEvent event) {
        ServerLevel serverLevel = event.getLevel();
        if (serverLevel instanceof ServerLevel) {
            ServerLevel level = serverLevel;
            GreenThumb.checkAndApplyGreenThumbOnHarvest(level, event.getPos(), event.getState(), event.getDrops());
        }
    }

    @SubscribeEvent
    public static void removeNonApplicableGreenThumbDataOnChunkLoad(ChunkEvent.Load event) {
        if (!event.isNewChunk() && event.getLevel() instanceof ServerLevel) {
            GreenThumb.removeIrrelevantData(event.getChunk());
        }
    }
}

