/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.farmers_attributes.attribute;

import medi.makiba.farmers_attributes.FAConfig;
import medi.makiba.farmers_attributes.attribute.ParticleUtils;
import medi.makiba.farmers_attributes.registry.FAAttachmentTypes;
import medi.makiba.farmers_attributes.registry.FAAttributes;
import medi.makiba.farmers_attributes.registry.FATags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class CrouchBoneMeal {
    public static void tickCrouchBoneMeal(ServerLevel level, ServerPlayer player) {
        if (player.isCrouching()) {
            CrouchBoneMeal.tryGrow(level, player);
        } else {
            CrouchBoneMeal.resetCooldown(player);
        }
    }

    public static void resetCooldown(ServerPlayer player) {
        if (player.hasData(FAAttachmentTypes.CROUCH_BONEMEAL_COOLDOWN)) {
            player.setData(FAAttachmentTypes.CROUCH_BONEMEAL_COOLDOWN, (Object)0);
        }
    }

    public static void tryGrow(ServerLevel level, ServerPlayer player) {
        double chance = player.getAttributeValue(FAAttributes.CROUCH_BONEMEAL_CHANCE);
        if (chance <= 0.0 || chance < level.random.nextDouble()) {
            return;
        }
        int current_cooldown = (Integer)player.getData(FAAttachmentTypes.CROUCH_BONEMEAL_COOLDOWN);
        if (0 < current_cooldown) {
            player.setData(FAAttachmentTypes.CROUCH_BONEMEAL_COOLDOWN, (Object)(current_cooldown - 1));
            return;
        }
        player.setData(FAAttachmentTypes.CROUCH_BONEMEAL_COOLDOWN, (Object)((Integer)FAConfig.CROUCH_BONEMEAL_COOLDOWN.get()));
        int range = (Integer)FAConfig.CROUCH_BONEMEAL_RANGE.get();
        BlockPos pos = player.blockPosition();
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    Boolean result;
                    BonemealableBlock bonemealableBlock;
                    Block block;
                    BlockPos offsetLocation = pos.offset(x, y, z);
                    BlockState offsetState = level.getBlockState(offsetLocation);
                    if (offsetState.isAir() || !offsetState.is(FATags.Blocks.CROUCH_BONEMEAL_WHITELIST) || !((block = offsetState.getBlock()) instanceof BonemealableBlock) || !(bonemealableBlock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, offsetLocation, offsetState) || !(result = Boolean.valueOf(BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)level, (BlockPos)offsetLocation, (Player)player))).booleanValue()) continue;
                    int count = 2;
                    switch (bonemealableBlock.getType()) {
                        case NEIGHBOR_SPREADER: {
                            ParticleUtils.spawnParticles(player, offsetLocation, count * 3, 3.0, 1.0, false, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                            break;
                        }
                        case GROWER: {
                            ParticleUtils.spawnParticleInBlock(player, offsetLocation, count, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                        }
                    }
                    player.level().playSound(null, offsetLocation, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            }
        }
    }
}

