/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.farmers_attributes.attribute;

import medi.makiba.farmers_attributes.FAConfig;
import medi.makiba.farmers_attributes.registry.FAAttributes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Math;

public class ShortOrderCooking {
    private static double getCookingSpeedMultiplier(ServerLevel level, BlockPos pos) {
        int range = (Integer)FAConfig.SHORT_ORDER_COOKING_RANGE.get();
        AABB area = new AABB((double)(pos.getX() - range), (double)(pos.getY() - range), (double)(pos.getZ() - range), (double)(pos.getX() + range), (double)(pos.getY() + range), (double)(pos.getZ() + range));
        double multiplier = 1.0;
        for (Player player : level.players()) {
            if (!area.contains(player.getX(), player.getY(), player.getZ())) continue;
            double attributeValue = player.getAttributeValue(FAAttributes.SHORT_ORDER_COOKING);
            multiplier *= attributeValue;
        }
        return multiplier;
    }

    private static int multiplyCookTimeIncrement(int originalCookTimeInc, double multiplier, Level level) {
        double newCookTime = (double)originalCookTimeInc * multiplier;
        int integerPart = (int)Math.floor((double)newCookTime);
        double fractionalPart = newCookTime - (double)integerPart;
        if (level.getRandom().nextDouble() < fractionalPart) {
            ++integerPart;
        }
        return integerPart;
    }

    public static int getModifiedCookTimeIncrement(ServerLevel level, BlockEntity entity, int originalCookTimeInc) {
        double multiplier = ShortOrderCooking.getCookingSpeedMultiplier(level, entity.getBlockPos());
        return ShortOrderCooking.multiplyCookTimeIncrement(originalCookTimeInc, multiplier, (Level)level);
    }

    public static int getModifiedCookingTimeDuration(ServerPlayer player, int originalCookingTime) {
        double attributeValue = player.getAttributeValue(FAAttributes.SHORT_ORDER_COOKING);
        return attributeValue <= 0.001 ? originalCookingTime * 1000 : (int)Math.round((double)((double)originalCookingTime / attributeValue));
    }
}

