/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.farmers_attributes.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import medi.makiba.farmers_attributes.effect.AppetiteEffect;
import medi.makiba.farmers_attributes.registry.FAAttributes;
import medi.makiba.farmers_attributes.registry.FAMobEffects;
import medi.makiba.farmers_attributes.registry.FATags;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @ModifyExpressionValue(method={"addEatEffect"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodProperties$PossibleEffect;effect()Lnet/minecraft/world/effect/MobEffectInstance;")})
    private MobEffectInstance modifyEffectDuration(MobEffectInstance effectInstance) {
        if (((LivingEntity)this).hasEffect(FAMobEffects.APPETITE_EFFECT)) {
            return AppetiteEffect.getModifiedEffect(effectInstance, ((LivingEntity)this).getEffect(FAMobEffects.APPETITE_EFFECT).getAmplifier());
        }
        return effectInstance;
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"))
    private float modifyFarmerDamage(float damage, DamageSource source) {
        if (damage < 0.0f) {
            return damage;
        }
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack weapon = source.getWeaponItem();
            if (weapon != null && weapon.is(FATags.Items.FARMERS_WEAPON)) {
                damage += (float)player.getAttributeValue(FAAttributes.FARMERS_WEAPON);
            }
        }
        return damage;
    }

    @ModifyExpressionValue(method={"getArmorValue"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getAttributeValue(Lnet/minecraft/core/Holder;)D")})
    private double modifyFarmerArmor(double armorAttributeValue) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            Player player = (Player)livingEntityMixin;
            double attValue = player.getAttributeValue(FAAttributes.FARMERS_ARMOR);
            if (attValue == 0.0) {
                return armorAttributeValue;
            }
            double equipped = 0.0;
            for (ItemStack armorItem : player.getArmorSlots()) {
                if (armorItem == null || !armorItem.is(FATags.Items.FARMERS_ARMOR)) continue;
                equipped += 1.0;
            }
            return armorAttributeValue + attValue * equipped;
        }
        return armorAttributeValue;
    }
}

