/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.farmers_attributes.mixin;

import java.util.List;
import java.util.Set;
import medi.makiba.farmers_attributes.FarmersAttributes;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    private static final String FARMERS_DELIGHT_ID = "farmersdelight";
    private String ownPackage;
    private boolean farmersDelightInstalled;

    public void onLoad(String mixinPackage) {
        this.ownPackage = mixinPackage;
        this.farmersDelightInstalled = MixinPlugin.isModLoaded(FARMERS_DELIGHT_ID);
        if (this.farmersDelightInstalled) {
            FarmersAttributes.LOGGER.info("Farmer's Delight detected, enabling compatibility mixins.");
        }
    }

    private static Boolean isModLoaded(String modid) {
        return ModList.get() != null ? ModList.get().isLoaded(modid) : LoadingModList.get().getModFileById(modid) != null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String mixinShortName = mixinClassName.substring(this.ownPackage.length() + 1);
        if (mixinShortName.startsWith(FARMERS_DELIGHT_ID)) {
            return this.farmersDelightInstalled;
        }
        return true;
    }

    public String getRefMapperConfig() {
        return null;
    }

    public List<String> getMixins() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

