/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.farmers_attributes.attribute;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import medi.makiba.farmers_attributes.registry.FAAttributes;
import medi.makiba.farmers_attributes.registry.FATags;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;

public class FarmersWeaponAndArmor {
    public static void addTooltipToFarmersTools(AddAttributeTooltipsEvent event) {
        MutableComponent tooltipText;
        String valueString;
        ItemStack stack = event.getStack();
        if (stack == null || stack.isEmpty() || !event.shouldShow()) {
            return;
        }
        boolean isFarmersWeapon = stack.is(FATags.Items.FARMERS_WEAPON);
        boolean isFarmersArmor = stack.is(FATags.Items.FARMERS_ARMOR);
        if (!isFarmersWeapon && !isFarmersArmor) {
            return;
        }
        Player player = event.getContext().player();
        double weaponBonus = player != null && isFarmersWeapon ? player.getAttributeValue(FAAttributes.FARMERS_WEAPON) : 0.0;
        double armorBonus = player != null && isFarmersArmor ? player.getAttributeValue(FAAttributes.FARMERS_ARMOR) : 0.0;
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        decimalFormat.setRoundingMode(RoundingMode.CEILING);
        if (isFarmersArmor) {
            valueString = decimalFormat.format(armorBonus);
            tooltipText = player != null ? Component.literal((String)("+" + valueString + " ")) : Component.literal((String)"+? ");
            tooltipText.append((Component)Component.translatable((String)"tooltip.farmers_attributes.armor_bonus"));
            if (event.getContext().flag().isAdvanced()) {
                tooltipText.append((Component)Component.literal((String)(" [+ " + valueString + "]")).withStyle(ChatFormatting.GRAY));
            }
            event.addTooltipLines(new Component[]{tooltipText.withStyle(ChatFormatting.BLUE)});
        }
        if (isFarmersWeapon) {
            valueString = decimalFormat.format(weaponBonus);
            tooltipText = player != null ? Component.literal((String)("+" + valueString + " ")) : Component.literal((String)"+? ");
            tooltipText.append((Component)Component.translatable((String)"tooltip.farmers_attributes.weapon_bonus"));
            if (event.getContext().flag().isAdvanced()) {
                tooltipText.append((Component)Component.literal((String)(" [+ " + valueString + "]")).withStyle(ChatFormatting.GRAY));
            }
            event.addTooltipLines(new Component[]{tooltipText.withStyle(ChatFormatting.BLUE)});
        }
    }
}

