/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.farmers_attributes.block;

import javax.annotation.Nullable;
import medi.makiba.farmers_attributes.attribute.EasyHarvest;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeCropBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty IN_GROUND = BooleanProperty.create((String)"in_ground");
    private static final VoxelShape SHAPE_IN_GROUND = Block.box((double)0.0, (double)-12.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public BlockState originalCropState;

    public LargeCropBlock(BlockState originalCropState) {
        super(BlockBehaviour.Properties.of().destroyTime(1.0f).explosionResistance(1.0f).sound(SoundType.WOOD));
        this.originalCropState = originalCropState;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)IN_GROUND, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (heldStack.is(ItemTags.SHOVELS)) {
            if (((Boolean)state.getValue((Property)IN_GROUND)).booleanValue()) {
                LargeCropBlock.unEarth((Entity)player, state, level, pos);
                if (!level.isClientSide) {
                    heldStack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)hand));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (LargeCropBlock.getEarthedState(state).canSurvive((LevelReader)level, pos)) {
                LargeCropBlock.earth((Entity)player, state, level, pos);
                if (!level.isClientSide) {
                    heldStack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)hand));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else if (((Boolean)state.getValue((Property)IN_GROUND)).booleanValue() && EasyHarvest.tryHarvestLargeCrop(level, pos, player, heldStack)) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(heldStack, state, level, pos, player, hand, result);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, IN_GROUND});
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)IN_GROUND)).booleanValue()) {
            return SHAPE_IN_GROUND;
        }
        return Shapes.block();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getNearestLookingDirection().getOpposite());
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            LargeCropBlock.unEarth(null, state, (Level)level, pos);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)IN_GROUND)).booleanValue()) {
            BlockState blockstate = level.getBlockState(pos.below());
            return blockstate.getBlock() instanceof FarmBlock;
        }
        return true;
    }

    private static void unEarth(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        level.playSound(entity, pos, SoundEvents.CROP_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!level.isClientSide) {
            BlockState blockstate = LargeCropBlock.pushEntitiesUp((BlockState)state, (BlockState)((BlockState)state.setValue((Property)IN_GROUND, (Comparable)Boolean.valueOf(false))), (LevelAccessor)level, (BlockPos)pos);
            level.setBlockAndUpdate(pos, blockstate);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
        }
    }

    private static void earth(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        level.playSound(entity, pos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!level.isClientSide) {
            BlockState blockstate = LargeCropBlock.getEarthedState(state);
            level.setBlockAndUpdate(pos, blockstate);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
        }
    }

    public static BlockState getEarthedState(BlockState state) {
        return (BlockState)((BlockState)state.setValue((Property)IN_GROUND, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.UP);
    }

    public static boolean inGround(BlockState state) {
        return (Boolean)state.getValue((Property)IN_GROUND);
    }
}

