/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.farmers_attributes.item;

import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.SimpleTier;

public class SharpCarrot
extends SwordItem {
    private static Tier tier = new SimpleTier(BlockTags.INCORRECT_FOR_WOODEN_TOOL, 250, 2.0f, 0.0f, 15, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}));
    private static FoodProperties foodProperties = new FoodProperties.Builder().nutrition(12).saturationModifier(0.6f).build();

    public SharpCarrot() {
        super(tier, new Item.Properties().attributes(SharpCarrot.createAttributes((Tier)tier, (float)3.5f, (float)-2.4f)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (player.canEat(foodProperties.canAlwaysEat())) {
            player.startUsingItem(usedHand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return foodProperties.eatDurationTicks();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        livingEntity.eat(level, stack.copy(), foodProperties);
        stack.hurtAndBreak(80, livingEntity, livingEntity.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        return stack;
    }
}

