/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.farmers_attributes.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import medi.makiba.farmers_attributes.attribute.ShortOrderCooking;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public class AbstractFurnaceBlockEntityMixin {
    @Shadow
    protected int cookingProgress;
    @Shadow
    protected int cookingTotalTime;

    @ModifyExpressionValue(method={"serverTick"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;cookingProgress:I", opcode=180, ordinal=0, shift=At.Shift.AFTER)})
    private static int modifyCookTimeIncrement(int original, Level level, BlockPos pos, BlockState state, AbstractFurnaceBlockEntity instance) {
        if (!(instance instanceof SmokerBlockEntity) || !(level instanceof ServerLevel)) {
            return original;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AbstractFurnaceBlockEntityMixin mixinInstance = (AbstractFurnaceBlockEntityMixin)instance;
        return Math.clamp((long)ShortOrderCooking.getModifiedCookTimeIncrement(serverLevel, (BlockEntity)instance, original), 0, mixinInstance.cookingTotalTime - mixinInstance.cookingProgress);
    }
}

