/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.farmers_attributes.attribute;

import java.util.List;
import medi.makiba.farmers_attributes.FAConfig;
import medi.makiba.farmers_attributes.FarmersAttributes;
import medi.makiba.farmers_attributes.attribute.GreenThumb;
import medi.makiba.farmers_attributes.block.LargeCropBlock;
import medi.makiba.farmers_attributes.registry.FAAttachmentTypes;
import medi.makiba.farmers_attributes.registry.FAAttributes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.Tags;

public class EasyHarvest {
    public static boolean isEasyHarvestable(Level level, BlockPos pos, BlockState state, Direction face, ItemStack heldItem) {
        Boolean isHarvestable = false;
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            isHarvestable = cropBlock.getAge(state) == cropBlock.getMaxAge();
        } else if (block instanceof SugarCaneBlock) {
            isHarvestable = level.getBlockState(pos.below()).getBlock() == block && (face != Direction.UP || heldItem.getItem() != block.asItem());
        } else if (block instanceof GrowingPlantBlock) {
            GrowingPlantBlock growingPlantBlock = (GrowingPlantBlock)block;
            Item item = growingPlantBlock.getCloneItemStack((LevelReader)level, pos, state).getItem();
            isHarvestable = level.getBlockState(pos.below()).getBlock().getCloneItemStack((LevelReader)level, pos, state).getItem() == item && (face != Direction.UP || heldItem.getItem() != item);
        } else {
            return false;
        }
        return isHarvestable != false && !((List)FAConfig.EASY_HARVEST_BLACKLIST.get()).contains(BuiltInRegistries.BLOCK.getKey((Object)block).toString());
    }

    public static boolean tryHarvest(Level level, BlockPos pos, Player player, Direction face, ItemStack heldItem) {
        BlockState state = level.getBlockState(pos);
        if (!FAConfig.FORCE_EASY_HARVEST.getAsBoolean() && player.getAttributeValue(FAAttributes.EASY_HARVEST) == 0.0 || !EasyHarvest.isEasyHarvestable(level, pos, state, face, heldItem) || player.isCrouching() || !level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            return false;
        }
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Block block = state.getBlock();
        BlockState replacementState = Blocks.AIR.defaultBlockState();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            List drops = Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)player, (ItemStack)heldItem);
            int greenThumbMultiplier = serverLevel.getChunk(pos).hasData(FAAttachmentTypes.GREEN_THUMB) ? (Integer)FAConfig.GREEN_THUMB_DROP_MULTIPLIER.get() : 1;
            List<ItemStack> extraDrops = List.of();
            ItemStack seed = cropBlock.getCloneItemStack((LevelReader)serverLevel, pos, state);
            for (ItemStack drop : drops) {
                int maxStackSize;
                int newCount = drop.getCount();
                if (!drop.is(Tags.Items.SEEDS)) {
                    newCount *= greenThumbMultiplier;
                }
                if (newCount > (maxStackSize = drop.getMaxStackSize())) {
                    drop.setCount(maxStackSize);
                    newCount -= maxStackSize;
                    while (newCount > 0) {
                        ItemStack newStack = drop.copy();
                        int count = Math.min(newCount, maxStackSize);
                        newStack.setCount(count);
                        newCount -= count;
                        extraDrops.add(newStack);
                    }
                } else {
                    drop.setCount(newCount);
                }
                if (!ItemStack.isSameItem((ItemStack)drop, (ItemStack)seed) || seed.getCount() != 1) continue;
                seed.grow(1);
                drop.shrink(1);
            }
            if (seed.getCount() > 1) {
                replacementState = cropBlock.getStateForAge(0);
            } else if (player.getInventory().contains(seed)) {
                int slot = player.getInventory().findSlotMatchingItem(seed);
                player.getInventory().removeItem(slot, 1);
                replacementState = cropBlock.getStateForAge(0);
            }
            drops.addAll(extraDrops);
            EasyHarvest.harvestAndReplant(serverLevel, pos, state, replacementState, (ServerPlayer)player, drops, heldItem);
        } else if (block instanceof SugarCaneBlock) {
            EasyHarvest.harvestSugarCaneLike(serverLevel, pos, (ServerPlayer)player, state, replacementState, heldItem);
        } else if (block instanceof GrowingPlantBlock) {
            FluidState fluidState = state.getFluidState();
            if (!fluidState.isEmpty() && fluidState.isSource()) {
                replacementState = fluidState.createLegacyBlock();
            }
            EasyHarvest.harvestSugarCaneLike(serverLevel, pos, (ServerPlayer)player, state, replacementState, heldItem);
        }
        return true;
    }

    public static boolean tryHarvestLargeCrop(Level level, BlockPos pos, Player player, ItemStack heldItem) {
        LargeCropBlock largeCropBlock;
        BlockState state;
        block5: {
            block4: {
                state = level.getBlockState(pos);
                Block block = state.getBlock();
                if (!(block instanceof LargeCropBlock)) break block4;
                largeCropBlock = (LargeCropBlock)block;
                if ((FAConfig.FORCE_EASY_HARVEST.getAsBoolean() || player.getAttributeValue(FAAttributes.EASY_HARVEST) != 0.0) && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !player.isCrouching()) break block5;
            }
            return false;
        }
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        EasyHarvest.harvestAndReplant(serverLevel, pos, state, largeCropBlock.originalCropState, (ServerPlayer)player, LargeCropBlock.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)player, (ItemStack)heldItem), heldItem);
        return true;
    }

    private static void harvestAndReplant(ServerLevel level, BlockPos pos, BlockState originalState, BlockState replacementState, ServerPlayer player, List<ItemStack> drops, ItemStack heldItem) {
        if (level.setBlockAndUpdate(pos, replacementState)) {
            GreenThumb.removeData(level, pos);
            level.playSound(null, pos, SoundEvents.CROP_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!replacementState.is(Blocks.AIR)) {
                double attributeValue = player.getAttributeValue(FAAttributes.GREEN_THUMB);
                if (level.random.nextDouble() < attributeValue) {
                    GreenThumb.addData(level, pos);
                }
            }
            for (ItemStack drop : drops) {
                if (player.addItem(drop)) continue;
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
            }
            FarmersAttributes.PUFFISH_SKILLS_COMPAT.addBreakExp(player, originalState, heldItem);
        }
    }

    private static void harvestSugarCaneLike(ServerLevel level, BlockPos pos, ServerPlayer player, BlockState originalState, BlockState replacementState, ItemStack heldItem) {
        List drops = Block.getDrops((BlockState)originalState, (ServerLevel)level, (BlockPos)pos, null, (Entity)player, (ItemStack)heldItem);
        if (!level.setBlockAndUpdate(pos, replacementState)) {
            return;
        }
        level.playSound(null, pos, SoundEvents.CROP_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (((Boolean)FAConfig.EASY_HARVEST_WHOLE_PLANT.get()).booleanValue()) {
            BlockState state;
            BlockPos abovePos = pos.above();
            while (level.getBlockState(abovePos) == originalState) {
                List newDrops = Block.getDrops((BlockState)originalState, (ServerLevel)level, (BlockPos)abovePos, null, (Entity)player, (ItemStack)heldItem);
                if (!level.setBlockAndUpdate(abovePos, replacementState)) break;
                drops.addAll(newDrops);
                abovePos = abovePos.above();
            }
            if ((state = level.getBlockState(abovePos)).getBlock() instanceof GrowingPlantHeadBlock) {
                FluidState fluidState = state.getFluidState();
                if (!fluidState.isEmpty() && fluidState.isSource()) {
                    replacementState = fluidState.createLegacyBlock();
                }
                List newDrops = Block.getDrops((BlockState)level.getBlockState(abovePos), (ServerLevel)level, (BlockPos)abovePos, null, (Entity)player, (ItemStack)heldItem);
                if (level.setBlockAndUpdate(abovePos, replacementState)) {
                    drops.addAll(newDrops);
                }
            }
        }
        for (ItemStack drop : drops) {
            if (player.addItem(drop)) continue;
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
        }
        FarmersAttributes.PUFFISH_SKILLS_COMPAT.addBreakExp(player, originalState, heldItem);
    }
}

