/*
 * Decompiled with CFR 0.152.
 */
package medi.makiba.farmers_attributes.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import medi.makiba.farmers_attributes.datagen.FABlockLootSubProvider;
import medi.makiba.farmers_attributes.datagen.FABlockStateProvider;
import medi.makiba.farmers_attributes.datagen.FABlockTagsProvider;
import medi.makiba.farmers_attributes.datagen.FAItemModelProvider;
import medi.makiba.farmers_attributes.datagen.FAItemTagsProvider;
import medi.makiba.farmers_attributes.datagen.FALangProviderEnUs;
import medi.makiba.farmers_attributes.datagen.FALangProviderJaJp;
import medi.makiba.farmers_attributes.datagen.FARecipeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="farmers_attributes")
public class FADataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new FALangProviderEnUs(output));
        generator.addProvider(event.includeClient(), (DataProvider)new FALangProviderJaJp(output));
        generator.addProvider(event.includeClient(), (DataProvider)new FABlockStateProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new FAItemModelProvider(output, existingFileHelper));
        FABlockTagsProvider blockTags = new FABlockTagsProvider(output, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new FAItemTagsProvider(output, lookupProvider, blockTags.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new FARecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(FABlockLootSubProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
    }
}

