/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.config;

import com.fedpol1.enchantips.EnchantipsClient;
import com.fedpol1.enchantips.config.ModCategory;
import com.fedpol1.enchantips.config.ModOption;
import com.fedpol1.enchantips.config.deserializer.ConfigTreeDeserializer;
import com.fedpol1.enchantips.config.deserializer.OldConfigTreeDeserializer;
import com.fedpol1.enchantips.config.serializer.ConfigTreeSerializer;
import com.fedpol1.enchantips.config.tree.ConfigTree;
import com.fedpol1.enchantips.config.tree.EnchantmentGroupNode;
import com.fedpol1.enchantips.config.tree.Node;
import com.fedpol1.enchantips.config.tree.visitor.ScreenVisitor;
import com.fedpol1.enchantips.gui.screen.ConfigScreen;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.TreeSet;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1887;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class ModConfig {
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("enchantips.json").toFile();

    public static void registerConfig() {
        EnchantipsClient.LOGGER.info("Initializing Enchantips configs");
        ModCategory.init();
        ModOption.init();
        ModConfig.readConfig();
        ModConfig.writeConfig();
    }

    public static void registerPerEnchantmentConfig(class_5455 registryManager) {
        Optional optionalWrapper = registryManager.method_46759(class_7924.field_41265);
        if (optionalWrapper.isEmpty()) {
            return;
        }
        class_7225.class_7226 wrapper = (class_7225.class_7226)optionalWrapper.get();
        int existingEnchantments = 0;
        int newEnchantments = 0;
        for (class_5321 key : wrapper.method_46754().toList()) {
            EnchantmentGroupNode group = (EnchantmentGroupNode)ModCategory.INDIVIDUAL_ENCHANTMENTS.getNode().getChild(key.method_29177().toString());
            if (group == null) {
                group = ModCategory.INDIVIDUAL_ENCHANTMENTS.addEnchantmentGroup((class_5321<class_1887>)key);
                ++newEnchantments;
            } else {
                ++existingEnchantments;
            }
            class_1887 enchantment = (class_1887)registryManager.method_30530(class_7924.field_41265).method_29107(key);
            if (enchantment == null) continue;
            group.setDescription(enchantment.comp_2686());
        }
        if (newEnchantments > 0) {
            ModConfig.writeConfig();
        }
        EnchantipsClient.LOGGER.info("Found {} pre-existing enchantments and {} new enchantments.", (Object)existingEnchantments, (Object)newEnchantments);
    }

    public static void deregisterUnusedEnchantmentConfig() {
        TreeSet<String> toRemove = new TreeSet<String>();
        for (Map.Entry<String, Node> entry : ModCategory.INDIVIDUAL_ENCHANTMENTS.getNode().getChildren()) {
            EnchantmentGroupNode ench;
            Node node = entry.getValue();
            if (!(node instanceof EnchantmentGroupNode) || (ench = (EnchantmentGroupNode)node).isKnown()) continue;
            toRemove.add(entry.getKey());
        }
        for (String element : toRemove) {
            ModCategory.INDIVIDUAL_ENCHANTMENTS.getNode().removeChild(element);
        }
        EnchantipsClient.LOGGER.info("Pruned {} enchantments.", (Object)toRemove.size());
    }

    public static void readConfig() throws NullPointerException {
        try {
            CONFIG_FILE.createNewFile();
            Scanner sc = new Scanner(CONFIG_FILE);
            StringBuilder fileContents = new StringBuilder();
            while (sc.hasNextLine()) {
                fileContents.append(sc.nextLine());
            }
            try {
                new GsonBuilder().registerTypeAdapter(ConfigTree.class, (Object)new ConfigTreeDeserializer()).create().fromJson(fileContents.toString(), ConfigTree.class);
            }
            catch (Exception e) {
                EnchantipsClient.LOGGER.info("Falling back on old config format.");
                new GsonBuilder().registerTypeAdapter(ConfigTree.class, (Object)new OldConfigTreeDeserializer()).create().fromJson(fileContents.toString(), ConfigTree.class);
            }
        }
        catch (JsonSyntaxException | IOException e) {
            EnchantipsClient.LOGGER.error("Could not read configuration file.\n{}", (Object)e.getMessage());
        }
    }

    public static void writeConfig() {
        String json = new GsonBuilder().registerTypeAdapter(ConfigTree.class, (Object)new ConfigTreeSerializer()).setPrettyPrinting().create().toJson((Object)ConfigTree.root);
        try {
            FileWriter fw = new FileWriter(CONFIG_FILE);
            fw.write(json);
            fw.close();
        }
        catch (IOException e) {
            EnchantipsClient.LOGGER.error("Could not write configuration file.\n{}", (Object)e.getMessage());
        }
    }

    public static class_437 createGui(class_437 parent) {
        if (ModOption.COMPACT_CONFIGURATION.getValue().booleanValue()) {
            return new ConfigScreen(parent);
        }
        return ((YetAnotherConfigLib)ConfigTree.root.accept(new ScreenVisitor(), null)).generateScreen(parent);
    }
}

