/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.config.data;

import com.fedpol1.enchantips.config.data.Data;
import com.fedpol1.enchantips.config.tree.OptionNode;
import com.fedpol1.enchantips.gui.widgets.info_line.ColorConfigInfoLine;
import com.fedpol1.enchantips.gui.widgets.info_line.ConfigInfoLine;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2561;

public class ColorOption
implements Data<Color> {
    private Color color;
    private final Color defaultValue;

    public ColorOption(int defaultValue) {
        this.color = new Color(defaultValue);
        this.defaultValue = new Color(defaultValue);
    }

    @Override
    public Color getValue() {
        return this.color == null ? this.getDefaultValue() : this.color;
    }

    @Override
    public String getStringValue() {
        return String.format(Locale.ROOT, "#%06X", this.getValue().getRGB() & 0xFFFFFF);
    }

    @Override
    public Color getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(Color v) {
        this.color = v;
    }

    @Override
    public boolean canSet(Color v) {
        return v != null;
    }

    @Override
    public void readStringValue(String s) {
        this.color = new Color(Integer.parseInt(s.substring(1), 16));
    }

    @Override
    public List<class_2561> getSaveTooltip(Color v) {
        if (this.canSet(v)) {
            return null;
        }
        return List.of(class_2561.method_43471((String)"enchantips.gui.setter.color.error.invalid"));
    }

    @Override
    public ConfigInfoLine<Color> getConfigLine(OptionNode<Color> optionNode) {
        return new ColorConfigInfoLine(this.getOptionTitle(optionNode), this.getOptionTooltip(optionNode), this, this.color);
    }

    @Override
    public Option<Color> getYaclOption(OptionNode<Color> optionNode) {
        return Option.createBuilder().binding((Object)this.getDefaultValue(), this::getValue, this::setValue).controller(ColorControllerBuilder::create).name(this.getOptionTitle(optionNode)).description(this.getOptionDescription(optionNode)).build();
    }
}

