/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.config.deserializer;

import com.fedpol1.enchantips.config.ModCategory;
import com.fedpol1.enchantips.config.tree.CategoryNode;
import com.fedpol1.enchantips.config.tree.ConfigTree;
import com.fedpol1.enchantips.config.tree.EnchantmentGroupNode;
import com.fedpol1.enchantips.config.tree.Node;
import com.fedpol1.enchantips.config.tree.OptionNode;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;

public class ConfigTreeDeserializer
implements JsonDeserializer<ConfigTree> {
    public ConfigTree deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ConfigTreeDeserializer.deserializeImpl(json, ConfigTree.root);
        return null;
    }

    private static void deserializeImpl(JsonElement json, Node node) {
        for (Map.Entry current : json.getAsJsonObject().asMap().entrySet()) {
            Node child = node.getChild((String)current.getKey());
            if (child == null) continue;
            if (child == ModCategory.INDIVIDUAL_ENCHANTMENTS.getNode()) {
                ConfigTreeDeserializer.deserializeEnchantments((JsonElement)current.getValue(), child);
                continue;
            }
            if (child instanceof OptionNode) {
                ((OptionNode)child).getData().readStringValue(((JsonElement)current.getValue()).getAsString());
                continue;
            }
            ConfigTreeDeserializer.deserializeImpl((JsonElement)current.getValue(), child);
        }
    }

    private static void deserializeEnchantments(JsonElement json, Node node) {
        if (node != ModCategory.INDIVIDUAL_ENCHANTMENTS.getNode()) {
            throw new IllegalStateException("Found enchantment outside of individual_enchantments.");
        }
        for (Map.Entry current : json.getAsJsonObject().asMap().entrySet()) {
            EnchantmentGroupNode group = ((CategoryNode)node).addEnchantmentGroup((String)current.getKey());
            ConfigTreeDeserializer.deserializeImpl((JsonElement)current.getValue(), group);
        }
    }
}

