/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.config.tree;

import com.fedpol1.enchantips.config.ModConfigData;
import com.fedpol1.enchantips.config.ModOption;
import com.fedpol1.enchantips.config.data.BooleanOption;
import com.fedpol1.enchantips.config.data.ColorOption;
import com.fedpol1.enchantips.config.data.Data;
import com.fedpol1.enchantips.config.data.IntegerOption;
import com.fedpol1.enchantips.config.tree.GroupNode;
import com.fedpol1.enchantips.config.tree.Node;
import com.fedpol1.enchantips.config.tree.OptionNode;
import com.fedpol1.enchantips.config.tree.visitor.TreeVisitor;
import java.awt.Color;
import net.minecraft.class_124;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5321;

public class EnchantmentGroupNode
extends GroupNode {
    private boolean known;
    private final String identifier;
    private class_2561 description;
    private final OptionNode<Color> minColor;
    private final OptionNode<Color> maxColor;
    private final OptionNode<Color> overmaxColor;
    private final OptionNode<Integer> order;
    private final OptionNode<Boolean> highlight;

    public EnchantmentGroupNode(String ench, Node parent) {
        super(ench, parent);
        ModConfigData.addEnchantment(ench, this);
        this.known = false;
        this.identifier = ench;
        this.description = class_2561.method_43471((String)"enchantment.enchantips.unknown").method_10862(class_2583.field_24360).method_27692(class_124.field_1056);
        this.minColor = this.addOption(new ColorOption(0x9F7F7F), "min_color", 0);
        this.maxColor = this.addOption(new ColorOption(0xFFDFDF), "max_color", 0);
        this.overmaxColor = this.addOption(new ColorOption(0xFFDF3F), "overmax_color", 0);
        this.order = this.addOption(new IntegerOption(0, -500000000, 500000000, 0), "order", 1);
        this.highlight = this.addOption(new BooleanOption(true), "highlight", 1);
    }

    protected EnchantmentGroupNode(class_5321<class_1887> key, Node parent) {
        this(key.method_29177().toString(), parent);
    }

    private <T> OptionNode<T> addOption(Data<T> data, String key, int tooltipLines) {
        OptionNode<T> opt = new OptionNode<T>(new ModOption<T>(data, key, tooltipLines), (Node)this);
        opt.fullName = this.parent.getFullName() + "." + opt.getName();
        return opt;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public class_2561 getDescription() {
        return this.description;
    }

    public void setDescription(class_2561 description) {
        this.known = true;
        this.description = description;
    }

    public boolean isKnown() {
        return this.known;
    }

    public OptionNode<Color> getMinColor() {
        return this.minColor;
    }

    public OptionNode<Color> getMaxColor() {
        return this.maxColor;
    }

    public OptionNode<Color> getOvermaxColor() {
        return this.overmaxColor;
    }

    public OptionNode<Integer> getOrder() {
        return this.order;
    }

    public OptionNode<Boolean> getHighlight() {
        return this.highlight;
    }

    public void setMinColor(Color value) {
        this.setProperty(this.minColor, value);
    }

    public void setMaxColor(Color value) {
        this.setProperty(this.maxColor, value);
    }

    public void setOvermaxColor(Color value) {
        this.setProperty(this.overmaxColor, value);
    }

    public void copyMaxColorToOvermaxColor() {
        this.setProperty(this.overmaxColor, this.maxColor.getValue());
    }

    public void setOrder(Integer value) {
        this.setProperty(this.order, value);
    }

    public void setHighlight(Boolean value) {
        this.setProperty(this.highlight, value);
    }

    private <T> void setProperty(OptionNode<T> property, T value) {
        if (property.parent != this) {
            throw new UnsupportedOperationException("Property must be a child.");
        }
        if (value == null) {
            property.getData().setValue(property.getData().getDefaultValue());
            return;
        }
        property.getData().setValue(value);
    }

    @Override
    public Object accept(TreeVisitor v, Object data) {
        return v.visit(this, data);
    }
}

