/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.gui;

import com.fedpol1.enchantips.config.ModOption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;

public class ScrollableTooltipSection {
    private static ScrollableTooltipSection activeSection;
    private static ScrollableTooltipSection previousNonEmpty;
    public static final ScrollableTooltipSection EMPTY;
    private final List<class_2561> text;
    private final int lineLimit;
    private int position;

    public ScrollableTooltipSection(List<class_2561> text, int limit) {
        this.text = text;
        this.position = 0;
        this.lineLimit = limit;
    }

    public static void setActiveSection(ScrollableTooltipSection s) {
        if (s == null) {
            throw new IllegalStateException("Active scrollable tooltip section cannot be null.");
        }
        if (activeSection != EMPTY) {
            previousNonEmpty = activeSection;
        }
        if (s != previousNonEmpty) {
            s.position = 0;
        }
        activeSection = s;
    }

    public static ScrollableTooltipSection getActiveSection() {
        return activeSection;
    }

    public void scroll(int step) {
        this.position = Math.min(Math.max(0, this.text.size() - this.lineLimit), Math.max(0, this.position + step));
    }

    public List<class_2561> getShownText() {
        return this.text.subList(this.position, Math.min(this.text.size(), this.position + this.lineLimit));
    }

    public List<class_2561> getShownTextAll() {
        ArrayList<class_2561> ret = new ArrayList<class_2561>();
        if (this.text.size() > this.lineLimit) {
            ret.add(this.startLine());
        }
        ret.addAll(this.getShownText());
        if (this.text.size() > this.lineLimit) {
            ret.add(this.endLine());
        }
        return ret;
    }

    private class_2561 startLine() {
        class_5250 valueText = class_5250.method_43477((class_7417)new class_8828.class_2585(Integer.toString(this.position)));
        return class_2561.method_43469((String)"enchantips.tooltip.scrollable.start", (Object[])new Object[]{valueText}).method_10862(class_2583.field_24360.method_36139(ModOption.DECORATION.getValue().getRGB()));
    }

    private class_2561 endLine() {
        class_5250 valueText = class_5250.method_43477((class_7417)new class_8828.class_2585(Integer.toString(Math.max(0, this.text.size() - this.lineLimit - this.position))));
        return class_2561.method_43469((String)"enchantips.tooltip.scrollable.end", (Object[])new Object[]{valueText}).method_10862(class_2583.field_24360.method_36139(ModOption.DECORATION.getValue().getRGB()));
    }

    static {
        EMPTY = new ScrollableTooltipSection(new ArrayList<class_2561>(), 1);
    }
}

