/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.gui.widgets.info_line;

import com.fedpol1.enchantips.gui.widgets.info_line.CollapsibleInfoLine;
import com.fedpol1.enchantips.gui.widgets.info_line.InfoLine;
import com.fedpol1.enchantips.gui.widgets.info_line.InfoMultiLine;
import com.fedpol1.enchantips.gui.widgets.info_line.ScrollableInfoLineContainer;
import java.util.ArrayList;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import org.jetbrains.annotations.Nullable;

public class InfoLineContainer
implements InfoMultiLine,
class_4068 {
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected boolean focused = false;
    protected CollapsibleInfoLine parent;
    protected ScrollableInfoLineContainer nearestScrollableParent;
    protected final ArrayList<InfoLine> lines;

    public InfoLineContainer(@Nullable CollapsibleInfoLine parent) {
        this.parent = parent;
        this.nearestScrollableParent = null;
        this.lines = new ArrayList();
    }

    @Override
    public void addLine(class_2561 t) {
        this.addLine(new InfoLine(t));
    }

    @Override
    public void addLine(InfoLine line) {
        if (line == null) {
            return;
        }
        line.parent = this;
        line.setNearestScrollableParent(this.nearestScrollableParent);
        this.lines.add(line);
    }

    public void removeLine(InfoLine line) {
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.lines.get(i) != line) continue;
            this.lines.remove(i);
            this.refresh(i);
            this.nearestScrollableParent.refresh(0);
            break;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight(int index) {
        int sum = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (i >= index) {
                return sum;
            }
            sum += this.lines.get(i).getHeight();
        }
        return sum;
    }

    public int getHeight() {
        return this.getHeight(this.lines.size());
    }

    public void setHeight() {
        this.height = 10;
    }

    public boolean isWithin(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.getHeight());
    }

    public InfoLine getLast() {
        InfoLine last = this.lines.getLast();
        if (last instanceof CollapsibleInfoLine) {
            CollapsibleInfoLine collapsible = (CollapsibleInfoLine)last;
            if (collapsible.isCollapsed() || collapsible.lines.lines.isEmpty()) {
                return collapsible;
            }
            return collapsible.lines.getLast();
        }
        return last;
    }

    public CollapsibleInfoLine getParent() {
        return this.parent;
    }

    public void refresh(int index) {
        this.x = this.parent.parent.x + 16;
        this.y = this.parent.parent.y + this.parent.parent.getHeight(index) + 10;
        if (this.parent.parent == this.nearestScrollableParent) {
            this.y += this.nearestScrollableParent.scrollHeight;
        }
        this.width = this.parent.parent.getWidth() - 16;
        this.height = this.getHeight();
        for (int i = 0; i < this.lines.size(); ++i) {
            this.lines.get(i).refresh(i);
        }
    }

    public void setNearestScrollableParent(ScrollableInfoLineContainer container) {
        this.nearestScrollableParent = container;
        for (InfoLine line : this.lines) {
            line.setNearestScrollableParent(container);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        for (InfoLine info : this.lines) {
            info.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        boolean ret = false;
        for (InfoLine line : this.lines) {
            ret = ret || line.method_25402(click, doubled);
        }
        return ret;
    }

    public boolean method_25404(class_11908 input) {
        boolean ret = false;
        for (InfoLine line : this.lines) {
            ret = ret || line.method_25404(input);
        }
        return ret;
    }

    public boolean method_25400(class_11905 input) {
        boolean ret = false;
        for (InfoLine line : this.lines) {
            ret = ret || line.method_25400(input);
        }
        return ret;
    }
}

